/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorActionHandler {
    private final boolean myRunForEachCaret;
    private boolean inExecution;

    protected EditorActionHandler() {
        this(false);
    }

    protected EditorActionHandler(boolean runForEachCaret) {
        this.myRunForEachCaret = runForEachCaret;
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Editor editor, DataContext dataContext) {
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.execute(editor, dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    public boolean executeInCommand(Editor editor, DataContext dataContext) {
        return true;
    }

    public boolean runForAllCarets() {
        return this.myRunForEachCaret;
    }

    public final void execute(final @NotNull Editor editor, @Nullable Caret contextCaret, final DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/actionSystem/EditorActionHandler", "execute"));
        }
        if (contextCaret == null && this.runForAllCarets()) {
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                @Override
                public void perform(Caret caret) {
                    EditorActionHandler.this.doExecute(editor, caret, dataContext);
                }
            });
        } else {
            this.doExecute(editor, contextCaret, dataContext);
        }
    }

    public DocCommandGroupId getCommandGroupId(Editor editor) {
        return DocCommandGroupId.noneGroupId(editor.getDocument());
    }
}

