/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.WeakList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyRangeMarkerFactory {
    private final Project myProject;
    private final ConcurrentMap<VirtualFile, WeakList<LazyMarker>> myMarkers;

    public LazyRangeMarkerFactory(@NotNull Project project, final @NotNull FileDocumentManager fileDocumentManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "<init>"));
        }
        if (fileDocumentManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "<init>"));
        }
        this.myMarkers = new ConcurrentWeakHashMap();
        this.myProject = project;
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentAdapter(){

            @Override
            public void beforeDocumentChange(DocumentEvent e) {
                VirtualFile docFile = fileDocumentManager.getFile(e.getDocument());
                if (docFile == null) {
                    return;
                }
                WeakList lazyMarkers = (WeakList)LazyRangeMarkerFactory.this.myMarkers.get(docFile);
                if (lazyMarkers == null) {
                    return;
                }
                List markers = lazyMarkers.toStrongList();
                ArrayList<LazyMarker> markersToRemove = new ArrayList<LazyMarker>();
                for (LazyMarker marker : markers) {
                    if (!Comparing.equal((Object)marker.getFile(), (Object)docFile)) continue;
                    marker.getOrCreateDelegate();
                    markersToRemove.add(marker);
                }
                lazyMarkers.removeAll(markersToRemove);
            }
        }, project);
    }

    private void addToLazyMarkersList(@NotNull LazyMarker marker, @NotNull VirtualFile file) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "addToLazyMarkersList"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "addToLazyMarkersList"));
        }
        List markers = (List)this.myMarkers.get(file);
        if (markers == null) {
            markers = (List)ConcurrencyUtil.cacheOrGet(this.myMarkers, (Object)file, (Object)new WeakList());
        }
        markers.add(marker);
    }

    public static LazyRangeMarkerFactory getInstance(Project project) {
        return ServiceManager.getService(project, LazyRangeMarkerFactory.class);
    }

    @NotNull
    public RangeMarker createRangeMarker(final @NotNull VirtualFile file, final int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "createRangeMarker"));
        }
        RangeMarker rangeMarker = ApplicationManager.getApplication().runReadAction(new Computable<RangeMarker>(){

            public RangeMarker compute() {
                OffsetLazyMarker marker = new OffsetLazyMarker(file, offset);
                LazyRangeMarkerFactory.this.addToLazyMarkersList(marker, file);
                return marker;
            }
        });
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "createRangeMarker"));
        }
        return rangeMarker;
    }

    @NotNull
    public RangeMarker createRangeMarker(final @NotNull VirtualFile file, final int line, final int column, final boolean persistent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "createRangeMarker"));
        }
        RangeMarker rangeMarker = ApplicationManager.getApplication().runReadAction(new Computable<RangeMarker>(){

            public RangeMarker compute() {
                Document document = FileDocumentManager.getInstance().getCachedDocument(file);
                if (document != null) {
                    int offset = LazyRangeMarkerFactory.calculateOffset(LazyRangeMarkerFactory.this.myProject, file, document, line, column);
                    return document.createRangeMarker(offset, offset, persistent);
                }
                LineColumnLazyMarker marker = new LineColumnLazyMarker(file, line, column);
                LazyRangeMarkerFactory.this.addToLazyMarkersList(marker, file);
                return marker;
            }
        });
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "createRangeMarker"));
        }
        return rangeMarker;
    }

    private static int calculateOffset(@NotNull Project project, @NotNull VirtualFile file, @NotNull Document document, int line, int column) {
        int offset;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "calculateOffset"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "calculateOffset"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/LazyRangeMarkerFactory", "calculateOffset"));
        }
        if (line < document.getLineCount()) {
            int lineStart = document.getLineStartOffset(line);
            int lineEnd = document.getLineEndOffset(line);
            CharSequence docText = document.getCharsSequence();
            int tabSize = CodeStyleFacade.getInstance(project).getTabSize(file.getFileType());
            offset = lineStart;
            for (int col = 0; offset < lineEnd && col < column; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
            }
        } else {
            offset = document.getTextLength();
        }
        return offset;
    }

    private class LineColumnLazyMarker
    extends LazyMarker {
        private final int myLine;
        private final int myColumn;

        private LineColumnLazyMarker(VirtualFile file, int line, int column) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/LazyRangeMarkerFactory$LineColumnLazyMarker", "<init>"));
            }
            super(file, -1);
            this.myLine = line;
            this.myColumn = column;
        }

        @Override
        @NotNull
        public RangeMarker createDelegate(@NotNull VirtualFile file, @NotNull Document document) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/LazyRangeMarkerFactory$LineColumnLazyMarker", "createDelegate"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/LazyRangeMarkerFactory$LineColumnLazyMarker", "createDelegate"));
            }
            int offset = LazyRangeMarkerFactory.calculateOffset(LazyRangeMarkerFactory.this.myProject, file, document, this.myLine, this.myColumn);
            RangeMarker rangeMarker = document.createRangeMarker(offset, offset);
            if (rangeMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/LazyRangeMarkerFactory$LineColumnLazyMarker", "createDelegate"));
            }
            return rangeMarker;
        }

        @Override
        public int getStartOffset() {
            this.getOrCreateDelegate();
            return super.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            this.getOrCreateDelegate();
            return super.getEndOffset();
        }
    }

    private static class OffsetLazyMarker
    extends LazyMarker {
        private OffsetLazyMarker(@NotNull VirtualFile file, int offset) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/LazyRangeMarkerFactory$OffsetLazyMarker", "<init>"));
            }
            super(file, offset);
        }

        @Override
        @NotNull
        public RangeMarker createDelegate(@NotNull VirtualFile file, @NotNull Document document) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/LazyRangeMarkerFactory$OffsetLazyMarker", "createDelegate"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/LazyRangeMarkerFactory$OffsetLazyMarker", "createDelegate"));
            }
            int offset = Math.min(this.myInitialOffset, document.getTextLength());
            RangeMarker rangeMarker = document.createRangeMarker(offset, offset);
            if (rangeMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/LazyRangeMarkerFactory$OffsetLazyMarker", "createDelegate"));
            }
            return rangeMarker;
        }
    }

    private static abstract class LazyMarker
    extends UserDataHolderBase
    implements RangeMarker {
        private RangeMarker myDelegate;
        private final VirtualFile myFile;
        protected final int myInitialOffset;

        private LazyMarker(@NotNull VirtualFile file, int offset) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/LazyRangeMarkerFactory$LazyMarker", "<init>"));
            }
            this.myFile = file;
            this.myInitialOffset = offset;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/LazyRangeMarkerFactory$LazyMarker", "getFile"));
            }
            return virtualFile;
        }

        @Nullable
        protected final RangeMarker getOrCreateDelegate() {
            if (this.myDelegate == null) {
                Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
                if (document == null) {
                    return null;
                }
                this.myDelegate = this.createDelegate(this.myFile, document);
            }
            return this.myDelegate;
        }

        @NotNull
        protected abstract RangeMarker createDelegate(@NotNull VirtualFile var1, @NotNull Document var2);

        @Override
        @NotNull
        public Document getDocument() {
            Document document = this.getOrCreateDelegate().getDocument();
            if (document == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/LazyRangeMarkerFactory$LazyMarker", "getDocument"));
            }
            return document;
        }

        @Override
        public int getStartOffset() {
            return this.myDelegate == null ? this.myInitialOffset : this.myDelegate.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.myDelegate == null ? this.myInitialOffset : this.myDelegate.getEndOffset();
        }

        @Override
        public boolean isValid() {
            RangeMarker delegate = this.getOrCreateDelegate();
            return delegate != null && delegate.isValid();
        }

        @Override
        public void setGreedyToLeft(boolean greedy) {
            this.getOrCreateDelegate().setGreedyToLeft(greedy);
        }

        @Override
        public void setGreedyToRight(boolean greedy) {
            this.getOrCreateDelegate().setGreedyToRight(greedy);
        }

        @Override
        public boolean isGreedyToRight() {
            return this.getOrCreateDelegate().isGreedyToRight();
        }

        @Override
        public boolean isGreedyToLeft() {
            return this.getOrCreateDelegate().isGreedyToLeft();
        }

        @Override
        public void dispose() {
            RangeMarker delegate = this.getOrCreateDelegate();
            if (delegate != null) {
                delegate.dispose();
            }
        }
    }
}

