/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClipboardTextPerCaretSplitter {
    public List<String> split(String input, int caretCount) {
        if (caretCount <= 0) {
            throw new IllegalArgumentException("Caret count must be positive");
        }
        if (caretCount == 1) {
            return Collections.singletonList(input);
        }
        ArrayList<String> result = new ArrayList<String>(caretCount);
        String[] lines = input.split("\n", -1);
        for (int i = 0; i < caretCount; ++i) {
            if (lines.length == 0) {
                result.add("");
                continue;
            }
            if (lines.length == 1) {
                result.add(lines[0]);
                continue;
            }
            if (lines.length % caretCount == 0) {
                StringBuilder b = new StringBuilder();
                int linesPerSegment = lines.length / caretCount;
                for (int j = 0; j < linesPerSegment; ++j) {
                    if (j > 0) {
                        b.append('\n');
                    }
                    b.append(lines[i * linesPerSegment + j]);
                }
                result.add(b.toString());
                continue;
            }
            result.add(i < lines.length ? lines[i] : "");
        }
        return result;
    }
}

