/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class ApplicationStarterBase
implements ApplicationStarterEx {
    private final String myCommandName;
    private final int[] myArgsCount;

    protected ApplicationStarterBase(String commandName, int ... possibleArgumentsCount) {
        this.myCommandName = commandName;
        this.myArgsCount = possibleArgumentsCount;
    }

    @Override
    public String getCommandName() {
        return this.myCommandName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processExternalCommandLine(String[] args) {
        if (!this.checkArguments(args)) {
            Messages.showMessageDialog(this.getUsageMessage(), StringUtil.toTitleCase((String)this.getCommandName()), Messages.getInformationIcon());
            return;
        }
        try {
            this.processCommand(args);
        }
        catch (Exception e) {
            Messages.showMessageDialog(String.format("Error showing %s: %s", this.getCommandName(), e.getMessage()), StringUtil.toTitleCase((String)this.getCommandName()), Messages.getErrorIcon());
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
    }

    private static void saveAll() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveSettings();
    }

    private boolean checkArguments(String[] args) {
        return Arrays.binarySearch(this.myArgsCount, args.length - 1) != -1 && this.getCommandName().equals(args[0]);
    }

    public abstract String getUsageMessage();

    protected abstract void processCommand(String[] var1) throws Exception;

    @Override
    public void premain(String[] args) {
        if (!this.checkArguments(args)) {
            System.err.println(this.getUsageMessage());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void main(String[] args) {
        try {
            this.processCommand(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(2);
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
        System.exit(0);
    }

    public static VirtualFile findOrCreateFile(String path) throws IOException {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path));
        if (file == null) {
            boolean result = new File(path).createNewFile();
            if (result) {
                return ApplicationStarterBase.findFile(path);
            }
            throw new FileNotFoundException("Can't create file " + path);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(VirtualFile file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file.getPath());
        try {
            String string = StreamUtil.readText((InputStream)inputStream);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static boolean haveDirs(VirtualFile ... files) {
        for (VirtualFile file : files) {
            if (!file.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static boolean areJars(VirtualFile file1, VirtualFile file2) {
        return "jar".equalsIgnoreCase(file1.getExtension()) && "jar".equalsIgnoreCase(file2.getExtension());
    }

    public static boolean areDirs(VirtualFile file1, VirtualFile file2) {
        return file1.isDirectory() && file2.isDirectory();
    }

    @NotNull
    public static VirtualFile findFile(String path) throws OperationFailedException {
        VirtualFile file;
        File ioFile = new File(path);
        if (!ioFile.exists()) {
            String dir = PathManager.getOriginalWorkingDir();
            ioFile = new File(dir + File.separator + path);
        }
        if ((file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile)) == null) {
            throw new OperationFailedException("Can't find file " + path);
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/ApplicationStarterBase", "findFile"));
        }
        return virtualFile;
    }

    public static class OperationFailedException
    extends IOException {
        public OperationFailedException(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/ApplicationStarterBase$OperationFailedException", "<init>"));
            }
            super(message);
        }
    }
}

