/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StateStorage {
    public static final Topic<Listener> STORAGE_TOPIC = new Topic("STORAGE_LISTENER", Listener.class, Topic.BroadcastDirection.TO_PARENT);

    @Nullable
    public <T> T getState(Object var1, String var2, Class<T> var3, @Nullable T var4) throws StateStorageException;

    public boolean hasState(Object var1, String var2, Class<?> var3, boolean var4) throws StateStorageException;

    @NotNull
    public ExternalizationSession startExternalization();

    @NotNull
    public SaveSession startSave(@NotNull ExternalizationSession var1);

    public void finishSave(@NotNull SaveSession var1);

    public void reload(@NotNull Set<String> var1) throws StateStorageException;

    public static interface Listener {
        public void storageFileChanged(@NotNull VirtualFileEvent var1, @NotNull StateStorage var2);
    }

    public static interface SaveSession {
        public void save() throws StateStorageException;

        @Nullable
        public Set<String> analyzeExternalChanges(@NotNull Set<Pair<VirtualFile, StateStorage>> var1);

        @NotNull
        public Collection<IFile> getStorageFilesToSave() throws StateStorageException;

        @NotNull
        public List<IFile> getAllStorageFiles();
    }

    public static interface ExternalizationSession {
        public void setState(@NotNull Object var1, String var2, @NotNull Object var3, @Nullable Storage var4) throws StateStorageException;
    }
}

