/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.openapi.compiler.ExportableUserDataHolder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportableUserDataHolderBase
extends UserDataHolderBase
implements ExportableUserDataHolder {
    private final Set<Key> myKeys = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final Map<Key, Object> exportUserData() {
        HashMap<Key, Object> result = new HashMap<Key, Object>();
        Set<Key> set = this.myKeys;
        synchronized (set) {
            for (Key k : this.myKeys) {
                Object data = this.getUserData(k);
                if (data == null) continue;
                result.put(k, data);
            }
        }
        HashMap<Key, Object> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/ExportableUserDataHolderBase", "exportUserData"));
        }
        return hashMap;
    }

    public final <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/compiler/ExportableUserDataHolderBase", "putUserData"));
        }
        if (value != null) {
            this.myKeys.add(key);
        } else {
            this.myKeys.remove(key);
        }
        super.putUserData(key, value);
    }
}

