/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyCompileContext
implements CompileContext {
    private static final DummyCompileContext OUR_INSTANCE = new DummyCompileContext();

    protected DummyCompileContext() {
    }

    public static DummyCompileContext getInstance() {
        return OUR_INSTANCE;
    }

    @Override
    public Project getProject() {
        return null;
    }

    @Override
    public void addMessage(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum) {
    }

    @Override
    public void addMessage(CompilerMessageCategory category, String message, @Nullable String url, int lineNum, int columnNum, Navigatable navigatable) {
    }

    @Override
    public CompilerMessage[] getMessages(CompilerMessageCategory category) {
        return CompilerMessage.EMPTY_ARRAY;
    }

    @Override
    public int getMessageCount(CompilerMessageCategory category) {
        return 0;
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return null;
    }

    @Override
    public CompileScope getCompileScope() {
        return null;
    }

    @Override
    public CompileScope getProjectCompileScope() {
        return null;
    }

    @Override
    public void requestRebuildNextTime(String message) {
    }

    @Override
    public boolean isRebuildRequested() {
        return false;
    }

    @Override
    @Nullable
    public String getRebuildReason() {
        return null;
    }

    @Override
    public Module getModuleByFile(VirtualFile file) {
        return null;
    }

    @Override
    public boolean isAnnotationProcessorsEnabled() {
        return false;
    }

    @Override
    public VirtualFile[] getSourceRoots(Module module) {
        return VirtualFile.EMPTY_ARRAY;
    }

    @Override
    public VirtualFile[] getAllOutputDirectories() {
        return VirtualFile.EMPTY_ARRAY;
    }

    @Override
    public VirtualFile getModuleOutputDirectory(final Module module) {
        return ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return CompilerModuleExtension.getInstance(module).getCompilerOutputPath();
            }
        });
    }

    @Override
    public VirtualFile getModuleOutputDirectoryForTests(Module module) {
        return null;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/compiler/DummyCompileContext", "getUserData"));
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/compiler/DummyCompileContext", "putUserData"));
        }
    }

    @Override
    public boolean isMake() {
        return false;
    }

    @Override
    public boolean isRebuild() {
        return false;
    }
}

