/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedSingletonsRegistry {
    private static final Object LOCK = new CachedSingletonsRegistry();
    private static final List<Class<?>> ourRegisteredClasses = new ArrayList();

    private CachedSingletonsRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T markCachedField(@NotNull Class<T> klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/application/CachedSingletonsRegistry", "markCachedField"));
        }
        Object object = LOCK;
        synchronized (object) {
            ourRegisteredClasses.add(klass);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupCachedFields() {
        Object object = LOCK;
        synchronized (object) {
            for (Class<?> aClass : ourRegisteredClasses) {
                try {
                    CachedSingletonsRegistry.cleanupClass(aClass);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void cleanupClass(Class<?> aClass) throws Exception {
        Field field = aClass.getDeclaredField("ourInstance");
        field.setAccessible(true);
        field.set(null, null);
    }
}

