/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.PluginId;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionManagerEx
extends ActionManager {
    public static ActionManagerEx getInstanceEx() {
        return (ActionManagerEx)ActionManagerEx.getInstance();
    }

    public abstract ActionToolbar createActionToolbar(String var1, @NotNull ActionGroup var2, boolean var3, boolean var4);

    public abstract void fireBeforeActionPerformed(AnAction var1, DataContext var2, AnActionEvent var3);

    public abstract void fireAfterActionPerformed(AnAction var1, DataContext var2, AnActionEvent var3);

    public abstract void fireBeforeEditorTyping(char var1, DataContext var2);

    public abstract String getLastPreformedActionId();

    public abstract String getPrevPreformedActionId();

    public abstract Comparator<String> getRegistrationOrderComparator();

    @Nullable
    public static KeyStroke getKeyStroke(String s) {
        KeyStroke result = null;
        try {
            result = KeyStroke.getKeyStroke(s);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (result == null && s != null && s.length() >= 2 && s.charAt(s.length() - 2) == ' ') {
            try {
                String s1 = s.substring(0, s.length() - 1) + Character.toUpperCase(s.charAt(s.length() - 1));
                result = KeyStroke.getKeyStroke(s1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @NotNull
    public abstract String[] getPluginActions(PluginId var1);

    public abstract void queueActionPerformedEvent(AnAction var1, DataContext var2, AnActionEvent var3);

    public abstract boolean isActionPopupStackEmpty();

    public abstract boolean isTransparentOnlyActionsUpdateNow();

    @NotNull
    public List<String> getAbbreviations() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/ActionManagerEx", "getAbbreviations"));
        }
        return list;
    }

    @NotNull
    public List<String> findActionIdsByAbbreviation(String abbreviation) {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/ActionManagerEx", "findActionIdsByAbbreviation"));
        }
        return list;
    }
}

