/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.SystemInfo;
import java.util.ArrayList;
import javax.swing.KeyStroke;

public class CommonShortcuts {
    public static final ShortcutSet ALT_ENTER = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 512));
    public static final ShortcutSet ENTER = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 0));
    public static final ShortcutSet CTRL_ENTER = new CustomShortcutSet(KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128));
    public static final ShortcutSet INSERT = new CustomShortcutSet(CommonShortcuts.getInsertKeystroke());
    public static final ShortcutSet DELETE = new CustomShortcutSet(KeyStroke.getKeyStroke(127, 0));
    public static final ShortcutSet ESCAPE = new CustomShortcutSet(KeyStroke.getKeyStroke(27, 0));
    public static final ShortcutSet DOUBLE_CLICK_1 = new CustomShortcutSet(new MouseShortcut(1, 0, 2));
    public static final ShortcutSet MOVE_UP = CustomShortcutSet.fromString("alt UP");
    public static final ShortcutSet MOVE_DOWN = CustomShortcutSet.fromString("alt DOWN");

    private CommonShortcuts() {
    }

    public static ShortcutSet getNewForDialogs() {
        ArrayList<Shortcut> shortcuts = new ArrayList<Shortcut>();
        for (Shortcut shortcut : CommonShortcuts.getNew().getShortcuts()) {
            if (CommonShortcuts.isCtrlEnter(shortcut)) continue;
            shortcuts.add(shortcut);
        }
        return new CustomShortcutSet(shortcuts.toArray(new Shortcut[shortcuts.size()]));
    }

    private static boolean isCtrlEnter(Shortcut shortcut) {
        if (shortcut instanceof KeyboardShortcut) {
            KeyStroke keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            return keyStroke.getKeyCode() == 10 && (keyStroke.getModifiers() & 2) != 0;
        }
        return false;
    }

    public static KeyStroke getInsertKeystroke() {
        return SystemInfo.isMac ? KeyStroke.getKeyStroke(78, 128) : KeyStroke.getKeyStroke(155, 0);
    }

    public static ShortcutSet getCopy() {
        return CommonShortcuts.shortcutsById("$Copy");
    }

    public static ShortcutSet getRerun() {
        return CommonShortcuts.shortcutsById("Rerun");
    }

    public static ShortcutSet getEditSource() {
        return CommonShortcuts.shortcutsById("EditSource");
    }

    public static ShortcutSet getViewSource() {
        return CommonShortcuts.shortcutsById("ViewSource");
    }

    public static ShortcutSet getNew() {
        return CommonShortcuts.shortcutsById("NewElement");
    }

    public static ShortcutSet getMove() {
        return CommonShortcuts.shortcutsById("Move");
    }

    public static ShortcutSet getRename() {
        return CommonShortcuts.shortcutsById("RenameElement");
    }

    public static ShortcutSet getDiff() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(68, SystemInfo.isMac ? 256 : 128));
    }

    public static ShortcutSet getFind() {
        return CommonShortcuts.shortcutsById("Find");
    }

    public static ShortcutSet getContextHelp() {
        return CommonShortcuts.shortcutsById("ContextHelp");
    }

    public static ShortcutSet getCloseActiveWindow() {
        return CommonShortcuts.shortcutsById("CloseContent");
    }

    public static ShortcutSet getMoveUp() {
        return CommonShortcuts.shortcutsById("EditorUp");
    }

    public static ShortcutSet getMoveDown() {
        return CommonShortcuts.shortcutsById("EditorDown");
    }

    public static ShortcutSet getMovePageUp() {
        return CommonShortcuts.shortcutsById("EditorPageUp");
    }

    public static ShortcutSet getMovePageDown() {
        return CommonShortcuts.shortcutsById("EditorPageDown");
    }

    public static ShortcutSet getMoveHome() {
        return CommonShortcuts.shortcutsById("EditorLineStart");
    }

    public static ShortcutSet getMoveEnd() {
        return CommonShortcuts.shortcutsById("EditorLineEnd");
    }

    public static ShortcutSet getRecentFiles() {
        return CommonShortcuts.shortcutsById("RecentFiles");
    }

    public static ShortcutSet getDelete() {
        return CommonShortcuts.shortcutsById("$Delete");
    }

    private static CustomShortcutSet shortcutsById(String actionId) {
        if (ApplicationManager.getApplication() == null) {
            return new CustomShortcutSet(Shortcut.EMPTY_ARRAY);
        }
        return new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId));
    }
}

