/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentTreeWatcher;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.DialogUtil;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;

public class MnemonicHelper
extends ComponentTreeWatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.MnemonicHelper");
    private Map<Integer, String> myMnemonics = null;
    public static final PropertyChangeListener TEXT_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof AbstractButton) {
                DialogUtil.registerMnemonic((AbstractButton)source);
            } else if (source instanceof JLabel) {
                DialogUtil.registerMnemonic((JLabel)source, null);
            }
        }
    };
    @NonNls
    public static final String TEXT_CHANGED_PROPERTY = "text";

    public MnemonicHelper() {
        super(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    @Override
    protected void processComponent(Component parentComponent) {
        if (parentComponent instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)parentComponent;
            abstractButton.addPropertyChangeListener(TEXT_CHANGED_PROPERTY, TEXT_LISTENER);
            DialogUtil.registerMnemonic(abstractButton);
            this.checkForDuplicateMnemonics(abstractButton);
        } else if (parentComponent instanceof JLabel) {
            KeyStroke[] strokes;
            InputMap inputMap;
            JLabel jLabel = (JLabel)parentComponent;
            jLabel.addPropertyChangeListener(TEXT_CHANGED_PROPERTY, TEXT_LISTENER);
            DialogUtil.registerMnemonic(jLabel, null);
            this.checkForDuplicateMnemonics(jLabel);
            if (SystemInfo.isMac && (inputMap = jLabel.getInputMap(2)) != null && (strokes = inputMap.allKeys()) != null) {
                for (KeyStroke stroke : strokes) {
                    int m = stroke.getModifiers();
                    if ((m & 8) != 8 || (m & 2) != 2) continue;
                    inputMap.put(KeyStroke.getKeyStroke(stroke.getKeyCode(), 8), "release");
                }
            }
        }
    }

    @Override
    protected void unprocessComponent(Component component) {
    }

    public void checkForDuplicateMnemonics(JLabel label) {
        if (!Registry.is((String)"ide.checkDuplicateMnemonics")) {
            return;
        }
        this.checkForDuplicateMnemonics(label.getDisplayedMnemonic(), label.getText());
    }

    public void checkForDuplicateMnemonics(AbstractButton button) {
        if (!Registry.is((String)"ide.checkDuplicateMnemonics")) {
            return;
        }
        this.checkForDuplicateMnemonics(button.getMnemonic(), button.getText());
    }

    public void checkForDuplicateMnemonics(int mnemonic, String text) {
        String other;
        if (mnemonic == 0) {
            return;
        }
        if (this.myMnemonics == null) {
            this.myMnemonics = new HashMap<Integer, String>();
        }
        if ((other = this.myMnemonics.get(mnemonic)) != null && !other.equals(text)) {
            LOG.error("conflict: multiple components with mnemonic '" + (char)mnemonic + "' seen on '" + text + "' and '" + other + "'");
        }
        this.myMnemonics.put(mnemonic, text);
    }
}

