/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.NotificationGroup");
    private static final Map<String, NotificationGroup> ourRegisteredGroups = ContainerUtil.newConcurrentMap();
    @NotNull
    private final String myDisplayId;
    @NotNull
    private final NotificationDisplayType myDisplayType;
    private final boolean myLogByDefault;
    @Nullable
    private final String myToolWindowId;

    public NotificationGroup(@NotNull String displayId, @NotNull NotificationDisplayType defaultDisplayType, boolean logByDefault) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/notification/NotificationGroup", "<init>"));
        }
        if (defaultDisplayType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/notification/NotificationGroup", "<init>"));
        }
        this(displayId, defaultDisplayType, logByDefault, null);
    }

    public NotificationGroup(@NotNull String displayId, @NotNull NotificationDisplayType defaultDisplayType, boolean logByDefault, @Nullable String toolWindowId) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/notification/NotificationGroup", "<init>"));
        }
        if (defaultDisplayType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/notification/NotificationGroup", "<init>"));
        }
        this.myDisplayId = displayId;
        this.myDisplayType = defaultDisplayType;
        this.myLogByDefault = logByDefault;
        this.myToolWindowId = toolWindowId;
        if (ourRegisteredGroups.containsKey(displayId)) {
            LOG.info("Notification group " + displayId + " is already registered", new Throwable());
        }
        ourRegisteredGroups.put(displayId, this);
    }

    public static NotificationGroup balloonGroup(@NotNull String displayId) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/notification/NotificationGroup", "balloonGroup"));
        }
        return new NotificationGroup(displayId, NotificationDisplayType.BALLOON, true);
    }

    public static NotificationGroup logOnlyGroup(@NotNull String displayId) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/notification/NotificationGroup", "logOnlyGroup"));
        }
        return new NotificationGroup(displayId, NotificationDisplayType.NONE, true);
    }

    public static NotificationGroup toolWindowGroup(@NotNull String displayId, @NotNull String toolWindowId, boolean logByDefault) {
        if (displayId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/notification/NotificationGroup", "toolWindowGroup"));
        }
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/notification/NotificationGroup", "toolWindowGroup"));
        }
        return new NotificationGroup(displayId, NotificationDisplayType.TOOL_WINDOW, logByDefault, toolWindowId);
    }

    public String getDisplayId() {
        return this.myDisplayId;
    }

    public Notification createNotification(@NotNull String content, @NotNull MessageType type) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        return this.createNotification(content, type.toNotificationType());
    }

    public Notification createNotification(@NotNull String content, @NotNull NotificationType type) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        return this.createNotification("", content, type, null);
    }

    public Notification createNotification(@NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/notification/NotificationGroup", "createNotification"));
        }
        return new Notification(this.myDisplayId, title, content, type, listener);
    }

    @NotNull
    public NotificationDisplayType getDisplayType() {
        NotificationDisplayType notificationDisplayType = this.myDisplayType;
        if (notificationDisplayType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "getDisplayType"));
        }
        return notificationDisplayType;
    }

    public boolean isLogByDefault() {
        return this.myLogByDefault;
    }

    @Nullable
    public String getToolWindowId() {
        return this.myToolWindowId;
    }

    @Nullable
    public static NotificationGroup findRegisteredGroup(String displayId) {
        return ourRegisteredGroups.get(displayId);
    }

    @NotNull
    public static Iterable<NotificationGroup> getAllRegisteredGroups() {
        Collection<NotificationGroup> collection = ourRegisteredGroups.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/NotificationGroup", "getAllRegisteredGroups"));
        }
        return collection;
    }
}

