/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class StoppableLexerAdapter
extends DelegateLexer {
    private final StoppingCondition myCondition;
    private boolean myStopped = false;

    public StoppableLexerAdapter(StoppingCondition condition, Lexer original) {
        super(original);
        this.myCondition = condition;
        this.myStopped = this.myCondition.stopsAt(original.getTokenType(), original.getTokenStart(), original.getTokenEnd());
    }

    @Override
    public void advance() {
        if (this.myStopped) {
            return;
        }
        super.advance();
        if (this.myCondition.stopsAt(this.getDelegate().getTokenType(), this.getDelegate().getTokenStart(), this.getDelegate().getTokenEnd())) {
            this.myStopped = true;
        }
    }

    public int getPrevTokenEnd() {
        Lexer delegate = this.getDelegate();
        return delegate instanceof StoppableLexerAdapter ? ((StoppableLexerAdapter)delegate).getPrevTokenEnd() : ((FilterLexer)delegate).getPrevTokenEnd();
    }

    @Override
    public int getTokenEnd() {
        return this.myStopped ? super.getTokenStart() : super.getTokenEnd();
    }

    @Override
    public IElementType getTokenType() {
        return this.myStopped ? null : super.getTokenType();
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        LexerPosition lexerPosition = this.getDelegate().getCurrentPosition();
        if (lexerPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lexer/StoppableLexerAdapter", "getCurrentPosition"));
        }
        return lexerPosition;
    }

    @Override
    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lexer/StoppableLexerAdapter", "restore"));
        }
        this.getDelegate().restore(position);
    }

    public static interface StoppingCondition {
        public boolean stopsAt(IElementType var1, int var2, int var3);
    }
}

