/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFoldingSurroundDescriptor
implements SurroundDescriptor {
    public static final CustomFoldingSurroundDescriptor INSTANCE = new CustomFoldingSurroundDescriptor();
    public static final CustomFoldingRegionSurrounder[] SURROUNDERS;
    private static final String DEFAULT_DESC_TEXT = "Description";

    @Override
    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement endElement;
        if (startOffset >= endOffset - 1) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file.getLanguage());
        if (commenter == null || commenter.getLineCommentPrefix() == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement startElement = file.findElementAt(startOffset);
        if (startElement instanceof PsiWhiteSpace) {
            startElement = startElement.getNextSibling();
        }
        if ((endElement = file.findElementAt(endOffset - 1)) instanceof PsiWhiteSpace) {
            endElement = endElement.getPrevSibling();
        }
        if (startElement != null && endElement != null) {
            if (startElement.getTextRange().getStartOffset() > endElement.getTextRange().getStartOffset()) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getElementsToSurround"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            if ((startElement = CustomFoldingSurroundDescriptor.findClosestParentAfterLineBreak(startElement)) != null && (endElement = CustomFoldingSurroundDescriptor.findClosestParentBeforeLineBreak(endElement)) != null) {
                PsiElement commonParent = startElement.getParent();
                if (endElement.getParent() == commonParent) {
                    if (startElement == endElement) {
                        PsiElement[] psiElementArray = new PsiElement[]{startElement};
                        if (psiElementArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getElementsToSurround"));
                        }
                        return psiElementArray;
                    }
                    PsiElement[] psiElementArray = new PsiElement[]{startElement, endElement};
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getElementsToSurround"));
                    }
                    return psiElementArray;
                }
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getElementsToSurround"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiElement findClosestParentAfterLineBreak(PsiElement element) {
        for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
            PsiElement prev;
            for (prev = parent.getPrevSibling(); prev != null && prev.getTextLength() <= 0; prev = prev.getPrevSibling()) {
            }
            if (!CustomFoldingSurroundDescriptor.isWhiteSpaceWithLineFeed(prev)) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    private static PsiElement findClosestParentBeforeLineBreak(PsiElement element) {
        for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
            PsiElement next = parent.getNextSibling();
            if (!CustomFoldingSurroundDescriptor.isWhiteSpaceWithLineFeed(next)) continue;
            return parent;
        }
        return null;
    }

    private static boolean isWhiteSpaceWithLineFeed(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiWhiteSpace) {
            return element.textContains('\n');
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        CharSequence text = node.getChars();
        boolean lineFeedFound = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isWhiteSpace((char)c)) {
                return false;
            }
            lineFeedFound |= c == '\n';
        }
        return lineFeedFound;
    }

    @Override
    @NotNull
    public Surrounder[] getSurrounders() {
        if (SURROUNDERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getSurrounders"));
        }
        return SURROUNDERS;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    static {
        ArrayList<CustomFoldingRegionSurrounder> surrounderList = new ArrayList<CustomFoldingRegionSurrounder>();
        for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
            surrounderList.add(new CustomFoldingRegionSurrounder(provider));
        }
        SURROUNDERS = surrounderList.toArray(new CustomFoldingRegionSurrounder[surrounderList.size()]);
    }

    private static class CustomFoldingRegionSurrounder
    implements Surrounder {
        private final CustomFoldingProvider myProvider;

        public CustomFoldingRegionSurrounder(@NotNull CustomFoldingProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "<init>"));
            }
            this.myProvider = provider;
        }

        @Override
        public String getTemplateDescription() {
            return this.myProvider.getDescription();
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement[] elements) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "isApplicable"));
            }
            if (elements.length == 0) {
                return false;
            }
            for (FoldingBuilder each : LanguageFolding.INSTANCE.allForLanguage(elements[0].getLanguage())) {
                if (!(each instanceof CustomFoldingBuilder)) continue;
                return true;
            }
            return false;
        }

        @Override
        public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "surroundElements"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "surroundElements"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "surroundElements"));
            }
            if (elements.length == 0) {
                return null;
            }
            PsiElement firstElement = elements[0];
            PsiElement lastElement = elements[elements.length - 1];
            PsiFile psiFile = firstElement.getContainingFile();
            Language language = psiFile.getLanguage();
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            if (commenter == null) {
                return null;
            }
            String linePrefix = commenter.getLineCommentPrefix();
            if (linePrefix == null) {
                return null;
            }
            int prefixLength = linePrefix.length();
            int startOffset = firstElement.getTextRange().getStartOffset();
            int endOffset = lastElement.getTextRange().getEndOffset();
            int delta = 0;
            TextRange rangeToSelect = new TextRange(startOffset, startOffset);
            String startText = this.myProvider.getStartString();
            int descPos = startText.indexOf("?");
            if (descPos >= 0) {
                startText = startText.replace("?", CustomFoldingSurroundDescriptor.DEFAULT_DESC_TEXT);
                rangeToSelect = new TextRange(startOffset + descPos, startOffset + descPos + CustomFoldingSurroundDescriptor.DEFAULT_DESC_TEXT.length());
            }
            String startString = linePrefix + startText + "\n";
            String endString = "\n" + linePrefix + this.myProvider.getEndString();
            editor.getDocument().insertString(endOffset, endString);
            delta += endString.length();
            editor.getDocument().insertString(startOffset, startString);
            rangeToSelect = rangeToSelect.shiftRight(prefixLength);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
            documentManager.commitDocument(documentManager.getDocument(psiFile));
            CustomFoldingRegionSurrounder.adjustLineIndent(project, psiFile, language, new TextRange(endOffset + (delta += startString.length()) - endString.length(), endOffset + delta));
            CustomFoldingRegionSurrounder.adjustLineIndent(project, psiFile, language, new TextRange(startOffset, startOffset + startString.length()));
            return rangeToSelect;
        }

        private static void adjustLineIndent(@NotNull Project project, PsiFile file, Language language, TextRange range) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "adjustLineIndent"));
            }
            CommonCodeStyleSettings formatSettings = CodeStyleSettingsManager.getSettings(project).getCommonSettings(language);
            boolean keepAtFirstCol = formatSettings.KEEP_FIRST_COLUMN_COMMENT;
            formatSettings.KEEP_FIRST_COLUMN_COMMENT = false;
            CodeStyleManager.getInstance(project).adjustLineIndent(file, range);
            formatSettings.KEEP_FIRST_COLUMN_COMMENT = keepAtFirstCol;
        }
    }
}

