/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.reference.SoftReference;
import com.intellij.util.ui.tree.TreeUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeState
implements JDOMExternalizable {
    @NonNls
    private static final String PATH = "PATH";
    @NonNls
    private static final String SELECTED = "SELECTED";
    @NonNls
    private static final String PATH_ELEMENT = "PATH_ELEMENT";
    @NonNls
    private static final String USER_OBJECT = "USER_OBJECT";
    @NonNls
    public static final String CALLBACK = "Callback";
    private final List<List<PathElement>> myExpandedPaths;
    private final List<List<PathElement>> mySelectedPaths;
    private boolean myScrollToSelection;

    private TreeState(List<List<PathElement>> expandedPaths, List<List<PathElement>> selectedPaths) {
        this.myExpandedPaths = expandedPaths;
        this.mySelectedPaths = selectedPaths;
        this.myScrollToSelection = true;
    }

    public TreeState() {
        this(new ArrayList<List<PathElement>>(), new ArrayList<List<PathElement>>());
    }

    public void readExternal(Element element) throws InvalidDataException {
        TreeState.readExternal(element, this.myExpandedPaths, PATH);
        TreeState.readExternal(element, this.mySelectedPaths, SELECTED);
    }

    private static void readExternal(Element element, List<List<PathElement>> list, String name) throws InvalidDataException {
        list.clear();
        List paths = element.getChildren(name);
        for (Object path : paths) {
            Element xmlPathElement = (Element)path;
            list.add(TreeState.readPath(xmlPathElement));
        }
    }

    private static List<PathElement> readPath(Element xmlPathElement) throws InvalidDataException {
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        List elements = xmlPathElement.getChildren(PATH_ELEMENT);
        for (Object element : elements) {
            Element xmlPathElementElement = (Element)element;
            PathElement pathElement = new PathElement();
            pathElement.readExternal(xmlPathElementElement);
            result.add(pathElement);
        }
        return result;
    }

    public static TreeState createOn(JTree tree, DefaultMutableTreeNode treeNode) {
        return new TreeState(TreeState.createExpandedPaths(tree, treeNode), TreeState.createSelectedPaths(tree, treeNode));
    }

    public static TreeState createOn(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/treeView/TreeState", "createOn"));
        }
        return new TreeState(TreeState.createPaths(tree), new ArrayList<List<PathElement>>());
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TreeState.writeExternal(element, this.myExpandedPaths, PATH);
        TreeState.writeExternal(element, this.mySelectedPaths, SELECTED);
    }

    private static void writeExternal(Element element, List<List<PathElement>> list, String name) throws WriteExternalException {
        for (List<PathElement> path : list) {
            Element pathElement = new Element(name);
            TreeState.writeExternal(pathElement, path);
            element.addContent(pathElement);
        }
    }

    private static void writeExternal(Element pathXmlElement, List<PathElement> path) throws WriteExternalException {
        for (PathElement aPath : path) {
            Element pathXmlElementElement = new Element(PATH_ELEMENT);
            aPath.writeExternal(pathXmlElementElement);
            pathXmlElement.addContent(pathXmlElementElement);
        }
    }

    private static List<List<PathElement>> createPaths(JTree tree) {
        ArrayList<List<PathElement>> result = new ArrayList<List<PathElement>>();
        List<TreePath> expandedPaths = TreeUtil.collectExpandedPaths(tree);
        for (TreePath expandedPath : expandedPaths) {
            List<PathElement> path = TreeState.createPath(expandedPath);
            if (path == null) continue;
            result.add(path);
        }
        return result;
    }

    private static List<List<PathElement>> createExpandedPaths(JTree tree, DefaultMutableTreeNode treeNode) {
        ArrayList<List<PathElement>> result = new ArrayList<List<PathElement>>();
        List<TreePath> expandedPaths = TreeUtil.collectExpandedPaths(tree, new TreePath(treeNode.getPath()));
        for (TreePath expandedPath : expandedPaths) {
            List<PathElement> path = TreeState.createPath(expandedPath);
            if (path == null) continue;
            result.add(path);
        }
        return result;
    }

    private static List<List<PathElement>> createSelectedPaths(JTree tree, DefaultMutableTreeNode treeNode) {
        ArrayList<List<PathElement>> result = new ArrayList<List<PathElement>>();
        List<TreePath> selectedPaths = TreeUtil.collectSelectedPaths(tree, new TreePath(treeNode.getPath()));
        for (TreePath expandedPath : selectedPaths) {
            List<PathElement> path = TreeState.createPath(expandedPath);
            if (path == null) continue;
            result.add(path);
        }
        return result;
    }

    private static List<PathElement> createPath(TreePath treePath) {
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            Object pathComponent = treePath.getPathComponent(i);
            if (pathComponent instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)pathComponent;
                TreeNode parent = node.getParent();
                Object userObject = node.getUserObject();
                if (userObject instanceof NodeDescriptor) {
                    NodeDescriptor nodeDescriptor = (NodeDescriptor)userObject;
                    int childIndex = parent != null ? parent.getIndex(node) : 0;
                    result.add(new PathElement(TreeState.getDescriptorKey(nodeDescriptor), TreeState.getDescriptorType(nodeDescriptor), childIndex, nodeDescriptor));
                    continue;
                }
                result.add(new PathElement("", "", 0, userObject));
                continue;
            }
            return null;
        }
        return result;
    }

    private static String getDescriptorKey(NodeDescriptor nodeDescriptor) {
        Object value;
        if (nodeDescriptor instanceof AbstractTreeNode && (value = nodeDescriptor instanceof NodeDescriptorProvidingKey ? ((NodeDescriptorProvidingKey)((Object)nodeDescriptor)).getKey() : ((AbstractTreeNode)nodeDescriptor).getValue()) instanceof NavigationItem) {
            try {
                String name = ((NavigationItem)value).getName();
                return name != null ? name : value.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nodeDescriptor.toString();
    }

    private static String getDescriptorType(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getClass().getName();
    }

    public void applyTo(JTree tree) {
        this.applyTo(tree, (DefaultMutableTreeNode)tree.getModel().getRoot());
    }

    private void applyExpanded(TreeFacade tree, Object root, ProgressIndicator indicator) {
        indicator.checkCanceled();
        if (!(root instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode nodeRoot = (DefaultMutableTreeNode)root;
        TreeNode[] nodePath = nodeRoot.getPath();
        if (nodePath.length > 0) {
            for (List<PathElement> path : this.myExpandedPaths) {
                TreeState.applyTo(nodePath.length - 1, path, root, tree, indicator);
            }
        }
    }

    public void applyTo(final JTree tree, final DefaultMutableTreeNode node) {
        final TreeFacade facade = TreeState.getFacade(tree);
        ActionCallback callback = facade.getInitialized().doWhenDone(new Runnable(){

            @Override
            public void run() {
                facade.batch(new Progressive(){

                    @Override
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/treeView/TreeState$1$1", "run"));
                        }
                        TreeState.this.applyExpanded(facade, node, indicator);
                    }
                });
            }
        });
        if (tree.getSelectionCount() == 0) {
            callback.doWhenDone(new Runnable(){

                @Override
                public void run() {
                    TreeState.this.applySelected(tree, node);
                }
            });
        }
    }

    private void applySelected(JTree tree, DefaultMutableTreeNode node) {
        TreeUtil.unselect(tree, node);
        ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
        for (List<PathElement> pathElements : this.mySelectedPaths) {
            TreeState.applySelectedTo(pathElements, tree.getModel().getRoot(), tree, selectionPaths, this.myScrollToSelection);
        }
        if (selectionPaths.size() > 1) {
            for (TreePath path : selectionPaths) {
                tree.addSelectionPath(path);
            }
        }
    }

    @Nullable
    private static DefaultMutableTreeNode findMatchedChild(DefaultMutableTreeNode parent, PathElement pathElement) {
        DefaultMutableTreeNode childNode;
        Object userObject;
        TreeNode child;
        int j;
        for (j = 0; j < parent.getChildCount(); ++j) {
            child = parent.getChildAt(j);
            if (!(child instanceof DefaultMutableTreeNode) || !pathElement.matchedWithByObject(userObject = (childNode = (DefaultMutableTreeNode)child).getUserObject())) continue;
            return childNode;
        }
        for (j = 0; j < parent.getChildCount(); ++j) {
            NodeDescriptor nodeDescriptor;
            child = parent.getChildAt(j);
            if (!(child instanceof DefaultMutableTreeNode) || !((userObject = (childNode = (DefaultMutableTreeNode)child).getUserObject()) instanceof NodeDescriptor) || !pathElement.matchedWith(nodeDescriptor = (NodeDescriptor)userObject)) continue;
            return childNode;
        }
        if (parent.getChildCount() > 0) {
            int index = pathElement.myItemIndex;
            if (index >= parent.getChildCount()) {
                index = parent.getChildCount() - 1;
            }
            if ((child = parent.getChildAt(index = Math.max(0, index))) instanceof DefaultMutableTreeNode) {
                return (DefaultMutableTreeNode)child;
            }
        }
        return null;
    }

    private static boolean applyTo(final int positionInPath, final List<PathElement> path, Object root, final TreeFacade tree, final ProgressIndicator indicator) {
        if (!(root instanceof DefaultMutableTreeNode)) {
            return false;
        }
        final DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)root;
        Object userObject = treeNode.getUserObject();
        PathElement pathElement = path.get(positionInPath);
        if (userObject instanceof NodeDescriptor ? !pathElement.matchedWith((NodeDescriptor)userObject) : !pathElement.matchedWithByObject(userObject)) {
            return false;
        }
        tree.expand(treeNode).doWhenDone(new Runnable(){

            @Override
            public void run() {
                TreeNode child;
                boolean resultFromChild;
                indicator.checkCanceled();
                if (positionInPath == path.size() - 1) {
                    return;
                }
                for (int j = 0; j < treeNode.getChildCount() && !(resultFromChild = TreeState.applyTo(positionInPath + 1, path, child = treeNode.getChildAt(j), tree, indicator)); ++j) {
                }
            }
        });
        return true;
    }

    private static void applySelectedTo(List<PathElement> path, Object root, JTree tree, List<TreePath> outSelectionPaths, boolean scrollToSelection) {
        for (int i = 1; i < path.size(); ++i) {
            if (!(root instanceof DefaultMutableTreeNode)) {
                return;
            }
            root = TreeState.findMatchedChild((DefaultMutableTreeNode)root, path.get(i));
        }
        if (!(root instanceof DefaultMutableTreeNode)) {
            return;
        }
        TreePath pathInNewTree = new TreePath(((DefaultMutableTreeNode)root).getPath());
        if (scrollToSelection) {
            TreeUtil.selectPath(tree, pathInNewTree);
        } else {
            tree.setSelectionPath(pathInNewTree);
        }
        outSelectionPaths.add(pathInNewTree);
    }

    private static TreeFacade getFacade(JTree tree) {
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
        return builder != null ? new BuilderFacade(builder) : new JTreeFacade(tree);
    }

    public void setScrollToSelection(boolean scrollToSelection) {
        this.myScrollToSelection = scrollToSelection;
    }

    static class BuilderFacade
    implements TreeFacade {
        private final AbstractTreeBuilder myBuilder;

        BuilderFacade(AbstractTreeBuilder builder) {
            this.myBuilder = builder;
        }

        @Override
        public ActionCallback getInitialized() {
            return this.myBuilder.getReady(this);
        }

        @Override
        public void batch(Progressive progressive) {
            this.myBuilder.batch(progressive);
        }

        @Override
        public ActionCallback expand(DefaultMutableTreeNode node) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeDescriptor)) {
                return new ActionCallback.Rejected();
            }
            NodeDescriptor desc = (NodeDescriptor)userObject;
            Object element = this.myBuilder.getTreeStructureElement(desc);
            ActionCallback result = new ActionCallback();
            this.myBuilder.expand(element, result.createSetDoneRunnable());
            return result;
        }
    }

    public static class JTreeFacade
    implements TreeFacade {
        private final JTree myTree;

        JTreeFacade(JTree tree) {
            this.myTree = tree;
        }

        @Override
        public ActionCallback expand(DefaultMutableTreeNode node) {
            this.myTree.expandPath(new TreePath(node.getPath()));
            return new ActionCallback.Done();
        }

        @Override
        public ActionCallback getInitialized() {
            WeakReference ref = (WeakReference)this.myTree.getClientProperty(TreeState.CALLBACK);
            ActionCallback callback = (ActionCallback)SoftReference.dereference((Reference)ref);
            if (callback != null) {
                return callback;
            }
            return new ActionCallback.Done();
        }

        @Override
        public void batch(Progressive progressive) {
            progressive.run(new EmptyProgressIndicator());
        }
    }

    static interface TreeFacade {
        public ActionCallback getInitialized();

        public ActionCallback expand(DefaultMutableTreeNode var1);

        public void batch(Progressive var1);
    }

    static class PathElement {
        public String myItemId;
        public String myItemType;
        private final int myItemIndex;
        private Object myUserObject;

        public PathElement(String itemId, String itemType, int itemIndex, Object userObject) {
            this.myItemId = itemId;
            this.myItemType = itemType;
            this.myItemIndex = itemIndex;
            this.myUserObject = userObject;
        }

        public PathElement() {
            this.myItemIndex = -1;
            this.myUserObject = null;
        }

        public String toString() {
            return this.myItemId + ":" + this.myItemType;
        }

        public boolean matchedWith(NodeDescriptor nodeDescriptor) {
            return Comparing.equal((String)this.myItemId, (String)TreeState.getDescriptorKey(nodeDescriptor)) && Comparing.equal((String)this.myItemType, (String)TreeState.getDescriptorType(nodeDescriptor));
        }

        public boolean matchedWithByObject(Object object) {
            return this.myUserObject != null && this.myUserObject.equals(object);
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
            this.myUserObject = element.getAttributeValue(TreeState.USER_OBJECT);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
            if (this.myUserObject instanceof String) {
                element.setAttribute(TreeState.USER_OBJECT, (String)this.myUserObject);
            }
        }
    }
}

