/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.facet.ui.libraries.LibraryInfo;
import org.jetbrains.annotations.NotNull;

public class FrameworkVersion {
    public static final FrameworkVersion[] EMPTY_ARRAY = new FrameworkVersion[0];
    private final String myVersionName;
    private final String myLibraryName;
    private final LibraryInfo[] myLibraries;
    private final boolean myDefault;

    public FrameworkVersion(String versionName) {
        this(versionName, false);
    }

    public FrameworkVersion(@NotNull String versionName, boolean isDefault) {
        if (versionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/FrameworkVersion", "<init>"));
        }
        this.myVersionName = versionName;
        this.myDefault = isDefault;
        this.myLibraryName = null;
        this.myLibraries = LibraryInfo.EMPTY_ARRAY;
    }

    public FrameworkVersion(String versionName, String libraryName, LibraryInfo[] libraries) {
        this(versionName, libraryName, libraries, false);
    }

    public FrameworkVersion(@NotNull String versionName, @NotNull String libraryName, @NotNull LibraryInfo[] libraries, boolean aDefault) {
        if (versionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/FrameworkVersion", "<init>"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/util/frameworkSupport/FrameworkVersion", "<init>"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/util/frameworkSupport/FrameworkVersion", "<init>"));
        }
        this.myVersionName = versionName;
        this.myLibraryName = libraryName;
        this.myLibraries = libraries;
        this.myDefault = aDefault;
    }

    public String getVersionName() {
        return this.myVersionName;
    }

    public String getLibraryName() {
        return this.myLibraryName;
    }

    public LibraryInfo[] getLibraries() {
        return this.myLibraries;
    }

    public boolean isDefault() {
        return this.myDefault;
    }
}

