/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.util.JDOMExternalizable;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class TodoPanelSettings
implements JDOMExternalizable {
    public boolean myArePackagesShown;
    public boolean myAreModulesShown;
    public boolean myAreFlattenPackages;
    public boolean myIsAutoScrollToSource;
    public String myTodoFilterName;
    public boolean myShowPreview;
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    private static final String ELEMENT_ARE_PACKAGES_SHOWN = "are-packages-shown";
    @NonNls
    private static final String ELEMENT_ARE_MODULES_SHOWN = "are-modules-shown";
    @NonNls
    private static final String ELEMENT_FLATTEN_PACKAGES = "flatten-packages";
    @NonNls
    private static final String ELEMENT_AUTOSCROLL_TO_SOURCE = "is-autoscroll-to-source";
    @NonNls
    private static final String ELEMENT_TODO_FILTER = "todo-filter";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ELEMENT_IS_PREVIEW_ENABLED = "is-preview-enabled";

    public TodoPanelSettings() {
    }

    public TodoPanelSettings(TodoPanelSettings s) {
        this.myArePackagesShown = s.myArePackagesShown;
        this.myAreModulesShown = s.myAreModulesShown;
        this.myAreFlattenPackages = s.myAreFlattenPackages;
        this.myIsAutoScrollToSource = s.myIsAutoScrollToSource;
        this.myTodoFilterName = s.myTodoFilterName;
    }

    public void readExternal(Element e) {
        for (Element child : e.getChildren()) {
            String childName = child.getName();
            if (ELEMENT_ARE_PACKAGES_SHOWN.equals(childName)) {
                this.myArePackagesShown = Boolean.valueOf(child.getAttributeValue(ATTRIBUTE_VALUE));
                continue;
            }
            if (ELEMENT_ARE_MODULES_SHOWN.equals(childName)) {
                this.myAreModulesShown = Boolean.valueOf(child.getAttributeValue(ATTRIBUTE_VALUE));
                continue;
            }
            if (ELEMENT_FLATTEN_PACKAGES.equals(childName)) {
                this.myAreFlattenPackages = Boolean.valueOf(child.getAttributeValue(ATTRIBUTE_VALUE));
                continue;
            }
            if (ELEMENT_AUTOSCROLL_TO_SOURCE.equals(childName)) {
                this.myIsAutoScrollToSource = Boolean.valueOf(child.getAttributeValue(ATTRIBUTE_VALUE));
                continue;
            }
            if (ELEMENT_TODO_FILTER.equals(childName)) {
                this.myTodoFilterName = child.getAttributeValue(ATTRIBUTE_NAME);
                continue;
            }
            if (!ELEMENT_IS_PREVIEW_ENABLED.equals(childName)) continue;
            this.myShowPreview = Boolean.valueOf(child.getAttributeValue(ELEMENT_IS_PREVIEW_ENABLED));
        }
    }

    public void writeExternal(Element e) {
        Element areArePackagesShownElement = new Element(ELEMENT_ARE_PACKAGES_SHOWN);
        areArePackagesShownElement.setAttribute(ATTRIBUTE_VALUE, this.myArePackagesShown ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        e.addContent(areArePackagesShownElement);
        Element areModulesShownElement = new Element(ELEMENT_ARE_MODULES_SHOWN);
        areModulesShownElement.setAttribute(ATTRIBUTE_VALUE, this.myAreModulesShown ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        e.addContent(areModulesShownElement);
        Element areAreFlattenPackagesElement = new Element(ELEMENT_FLATTEN_PACKAGES);
        areAreFlattenPackagesElement.setAttribute(ATTRIBUTE_VALUE, this.myAreFlattenPackages ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        e.addContent(areAreFlattenPackagesElement);
        Element isAutoScrollModeElement = new Element(ELEMENT_AUTOSCROLL_TO_SOURCE);
        isAutoScrollModeElement.setAttribute(ATTRIBUTE_VALUE, this.myIsAutoScrollToSource ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        e.addContent(isAutoScrollModeElement);
        if (this.myTodoFilterName != null) {
            Element todoFilterElement = new Element(ELEMENT_TODO_FILTER);
            todoFilterElement.setAttribute(ATTRIBUTE_NAME, this.myTodoFilterName);
            e.addContent(todoFilterElement);
        }
        if (this.myShowPreview) {
            Element showPreviewElement = new Element(ELEMENT_IS_PREVIEW_ENABLED);
            showPreviewElement.setAttribute(ATTRIBUTE_VALUE, Boolean.TRUE.toString());
            e.addContent(showPreviewElement);
        }
    }

    public boolean areModulesShown() {
        return this.myAreModulesShown;
    }

    public void setShownModules(boolean state) {
        this.myAreModulesShown = state;
    }

    public boolean arePackagesShown() {
        return this.myArePackagesShown;
    }

    public void setShownPackages(boolean state) {
        this.myArePackagesShown = state;
    }

    public boolean areFlattenPackages() {
        return this.myAreFlattenPackages;
    }

    public void setAreFlattenPackages(boolean state) {
        this.myAreFlattenPackages = state;
    }

    public boolean isAutoScrollToSource() {
        return this.myIsAutoScrollToSource;
    }

    public void setAutoScrollToSource(boolean state) {
        this.myIsAutoScrollToSource = state;
    }

    public String getTodoFilterName() {
        return this.myTodoFilterName;
    }

    public void setTodoFilterName(String todoFilterName) {
        this.myTodoFilterName = todoFilterName;
    }

    public boolean isShowPreview() {
        return this.myShowPreview;
    }

    public void setShowPreview(boolean showPreview) {
        this.myShowPreview = showPreview;
    }
}

