/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.projectWizard.ChooseTemplateStep;
import com.intellij.ide.projectWizard.ProjectTypeStep;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectWizardTestCase<T extends AbstractProjectWizard>
extends PlatformTestCase {
    protected static final String DEFAULT_SDK = "default";
    protected final List<Sdk> mySdks = new ArrayList<Sdk>();
    protected T myWizard;
    @Nullable
    private Project myCreatedProject;

    protected Project createProjectFromTemplate(String group, String name, @Nullable Consumer<Step> adjuster) throws IOException {
        this.runWizard(group, name, null, adjuster);
        try {
            this.myCreatedProject = NewProjectUtil.createFromWizard(this.myWizard, null);
        }
        catch (Throwable e) {
            this.myCreatedProject = (Project)ContainerUtil.find((Object[])this.myProjectManager.getOpenProjects(), (Condition)new Condition<Project>(){

                public boolean value(Project project) {
                    return ProjectWizardTestCase.this.myWizard.getProjectName().equals(project.getName());
                }
            });
            throw new RuntimeException(e);
        }
        ProjectWizardTestCase.assertNotNull((Object)this.myCreatedProject);
        UIUtil.dispatchAllInvocationEvents();
        Project[] projects = this.myProjectManager.getOpenProjects();
        ProjectWizardTestCase.assertEquals((String)Arrays.asList(projects).toString(), (int)2, (int)projects.length);
        return this.myCreatedProject;
    }

    @Nullable
    protected Module createModuleFromTemplate(String group, String name, @Nullable Consumer<Step> adjuster) throws IOException {
        this.runWizard(group, name, this.getProject(), adjuster);
        return this.createModuleFromWizard();
    }

    protected Module createModuleFromWizard() {
        return new NewModuleAction().createModuleFromWizard(this.myProject, null, this.myWizard);
    }

    protected void runWizard(String group, final String name, Project project, final @Nullable Consumer<Step> adjuster) throws IOException {
        this.createWizard(project);
        ProjectTypeStep step = (ProjectTypeStep)this.myWizard.getCurrentStepObject();
        boolean condition = step.setSelectedTemplate(group, name);
        if (!condition) {
            throw new IllegalArgumentException(group + "/" + name + " template not found");
        }
        this.runWizard(new Consumer<Step>(){

            public void consume(Step step) {
                if (name != null && step instanceof ChooseTemplateStep) {
                    ((ChooseTemplateStep)step).setSelectedTemplate(name);
                }
                if (adjuster != null) {
                    adjuster.consume((Object)step);
                }
            }
        });
    }

    protected void runWizard(Consumer<Step> adjuster) {
        block2: {
            ModuleWizardStep currentStep;
            do {
                currentStep = (ModuleWizardStep)this.myWizard.getCurrentStepObject();
                if (adjuster != null) {
                    adjuster.consume((Object)currentStep);
                }
                if (this.myWizard.isLast()) break block2;
                this.myWizard.doNextAction();
            } while (currentStep != this.myWizard.getCurrentStepObject());
            throw new RuntimeException(currentStep + " is not validated");
        }
        this.myWizard.doOk();
    }

    protected void createWizard(Project project) throws IOException {
        File directory = FileUtil.createTempDirectory((String)this.getName(), (String)"new", (boolean)false);
        myFilesToDelete.add(directory);
        this.myWizard = this.createWizard(project, directory);
        UIUtil.dispatchAllInvocationEvents();
    }

    protected Project createProject(Consumer<Step> adjuster) throws IOException {
        this.createWizard(null);
        this.runWizard(adjuster);
        this.myCreatedProject = NewProjectUtil.createFromWizard(this.myWizard, null);
        return this.myCreatedProject;
    }

    protected T createWizard(Project project, File directory) {
        return (T)new AddModuleWizard(project, DefaultModulesProvider.createForProject(project), directory.getPath());
    }

    protected void setUp() throws Exception {
        Sdk[] jdks;
        super.setUp();
        Sdk projectSdk = ProjectRootManager.getInstance(this.getProject()).getProjectSdk();
        for (final Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
            if (projectSdk == jdk) continue;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ProjectJdkTable.getInstance().removeJdk(jdk);
                }
            });
        }
    }

    protected void setupJdk() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
                Sdk defaultJdk = new SimpleJavaSdkType().createJdk(ProjectWizardTestCase.DEFAULT_SDK, SystemProperties.getJavaHome());
                Sdk otherJdk = new SimpleJavaSdkType().createJdk("_other", SystemProperties.getJavaHome());
                jdkTable.addJdk(otherJdk);
                jdkTable.addJdk(defaultJdk);
                ProjectWizardTestCase.this.mySdks.add(defaultJdk);
                ProjectWizardTestCase.this.mySdks.add(otherJdk);
                Sdk[] jdks = jdkTable.getAllJdks();
                System.out.println(Arrays.asList(jdks));
                if (ProjectWizardTestCase.this.getName().contains("DefaultSdk")) {
                    Project defaultProject = ProjectManager.getInstance().getDefaultProject();
                    ProjectRootManager.getInstance(defaultProject).setProjectSdk(defaultJdk);
                }
            }
        });
    }

    public void tearDown() throws Exception {
        if (this.myWizard != null) {
            Disposer.dispose((Disposable)this.myWizard.getDisposable());
        }
        if (this.myCreatedProject != null) {
            this.myProjectManager.closeProject(this.myCreatedProject);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)ProjectWizardTestCase.this.myCreatedProject);
                }
            });
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (Sdk sdk : ProjectWizardTestCase.this.mySdks) {
                    ProjectJdkTable.getInstance().removeJdk(sdk);
                }
            }
        });
        SelectTemplateSettings.getInstance().setLastTemplate(null, null);
        super.tearDown();
    }

    protected Module importModuleFrom(ProjectImportProvider provider, String path) {
        return this.importFrom(path, this.getProject(), null, provider);
    }

    protected Module importProjectFrom(String path, Consumer<Step> adjuster, ProjectImportProvider ... providers) {
        Module module = this.importFrom(path, null, adjuster, providers);
        if (module != null) {
            this.myCreatedProject = module.getProject();
        }
        return module;
    }

    private Module importFrom(String path, @Nullable Project project, Consumer<Step> adjuster, ProjectImportProvider ... providers) {
        List modules;
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        ProjectWizardTestCase.assertNotNull((String)("Can't find " + path), (Object)file);
        ProjectWizardTestCase.assertTrue((boolean)providers[0].canImport(file, project));
        this.myWizard = ImportModuleAction.createImportWizard((Project)project, null, (VirtualFile)file, (ProjectImportProvider[])providers);
        ProjectWizardTestCase.assertNotNull(this.myWizard);
        if (this.myWizard.getStepCount() > 0) {
            this.runWizard(adjuster);
        }
        return (modules = ImportModuleAction.createFromWizard((Project)project, this.myWizard)) == null || modules.isEmpty() ? null : (Module)modules.get(0);
    }

    protected Sdk createSdk(String name, SdkTypeId sdkType) {
        final Sdk sdk = ProjectJdkTable.getInstance().createSdk(name, sdkType);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectJdkTable.getInstance().addJdk(sdk);
            }
        });
        this.mySdks.add(sdk);
        return sdk;
    }
}

