/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.ide.diff.DiffElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffErrorElement
extends DiffElement {
    private final String myMessage;
    private final JTextArea myDescription;

    public DiffErrorElement() {
        this("Can't load children", "");
    }

    public DiffErrorElement(@NotNull String message, @NotNull String description) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/diff/DiffErrorElement", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/diff/DiffErrorElement", "<init>"));
        }
        this.myMessage = message;
        this.myDescription = new JTextArea(description);
        this.myDescription.setEditable(false);
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/diff/DiffErrorElement", "getName"));
        }
        return string;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public long getTimeStamp() {
        return -1L;
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public DiffElement[] getChildren() throws IOException {
        return EMPTY_ARRAY;
    }

    @Override
    public byte[] getContent() throws IOException {
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public Object getValue() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return PlatformIcons.ERROR_INTRODUCTION_ICON;
    }

    @Override
    public JComponent getViewComponent(Project project, @Nullable DiffElement target, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/diff/DiffErrorElement", "getViewComponent"));
        }
        return this.myDescription;
    }
}

