/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenInBrowserRequest {
    private Collection<Url> result;
    protected PsiFile file;

    public OpenInBrowserRequest(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/OpenInBrowserRequest", "<init>"));
        }
        this.file = file;
    }

    public OpenInBrowserRequest() {
    }

    @Nullable
    public static OpenInBrowserRequest create(final @NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/OpenInBrowserRequest", "create"));
        }
        PsiFile psiFile2 = psiFile = element.isValid() ? element.getContainingFile() : null;
        if (psiFile == null || psiFile.getVirtualFile() == null) {
            return null;
        }
        return new OpenInBrowserRequest(psiFile){

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiElement psiElement = element;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/OpenInBrowserRequest$1", "getElement"));
                }
                return psiElement;
            }
        };
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.file;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/OpenInBrowserRequest", "getFile"));
        }
        return psiFile;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.file.getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/OpenInBrowserRequest", "getVirtualFile"));
        }
        return virtualFile;
    }

    @NotNull
    public Project getProject() {
        Project project = this.file.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/OpenInBrowserRequest", "getProject"));
        }
        return project;
    }

    @NotNull
    public abstract PsiElement getElement();

    public void setResult(@NotNull Collection<Url> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/OpenInBrowserRequest", "setResult"));
        }
        this.result = result;
    }

    @Nullable
    public Collection<Url> getResult() {
        return this.result;
    }
}

