/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.CommonBundle;
import com.intellij.Patches;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.UrlOpener;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserLauncherAppless
extends BrowserLauncher {
    static final Logger LOG = Logger.getInstance(BrowserLauncherAppless.class);

    private static boolean isDesktopActionSupported(Desktop.Action action) {
        return !Patches.SUN_BUG_ID_6457572 && !Patches.SUN_BUG_ID_6486393 && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(action);
    }

    public static boolean canStartDefaultBrowser() {
        return BrowserLauncherAppless.isDesktopActionSupported(Desktop.Action.BROWSE) || SystemInfo.isMac || SystemInfo.isWindows || SystemInfo.isUnix && SystemInfo.hasXdgOpen();
    }

    private static GeneralSettings getGeneralSettingsInstance() {
        GeneralSettings settings;
        if (ApplicationManager.getApplication() != null && (settings = GeneralSettings.getInstance()) != null) {
            return settings;
        }
        return new GeneralSettings();
    }

    @Nullable
    private static List<String> getDefaultBrowserCommand() {
        if (SystemInfo.isWindows) {
            return Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote(""));
        }
        if (SystemInfo.isMac) {
            return Collections.singletonList(ExecUtil.getOpenCommandPath());
        }
        if (SystemInfo.isUnix && SystemInfo.hasXdgOpen()) {
            return Collections.singletonList("xdg-open");
        }
        return null;
    }

    @Override
    public void open(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserLauncherAppless", "open"));
        }
        this.openOrBrowse(url, false);
    }

    @Override
    public void browse(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserLauncherAppless", "browse"));
        }
        this.browse(VfsUtil.toUri(file));
    }

    @Override
    public void browse(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserLauncherAppless", "browse"));
        }
        LOG.debug("Launch browser: [" + uri + "]");
        GeneralSettings settings = BrowserLauncherAppless.getGeneralSettingsInstance();
        if (settings.isUseDefaultBrowser()) {
            List<String> command;
            if (BrowserLauncherAppless.isDesktopActionSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(uri);
                    LOG.debug("Browser launched using JDK 1.6 API");
                    return;
                }
                catch (Exception e) {
                    LOG.warn("Error while using Desktop API, fallback to CLI", (Throwable)e);
                }
            }
            if ((command = BrowserLauncherAppless.getDefaultBrowserCommand()) != null) {
                this.doLaunch(uri.toString(), command, null, null, ArrayUtil.EMPTY_STRING_ARRAY);
                return;
            }
        }
        this.browseUsingPath(uri.toString(), settings.getBrowserPath(), null, null, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    private void openOrBrowse(@NotNull String url, boolean browse) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserLauncherAppless", "openOrBrowse"));
        }
        if ((url = url.trim()).startsWith("jar:")) {
            String files = BrowserLauncherAppless.extractFiles(url);
            if (files == null) {
                return;
            }
            url = files;
        }
        if (!BrowserUtil.isAbsoluteURL(url)) {
            File file = new File(url);
            if (!browse && BrowserLauncherAppless.isDesktopActionSupported(Desktop.Action.OPEN)) {
                try {
                    Desktop.getDesktop().open(file);
                    return;
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
            this.browse(file);
            return;
        }
        URI uri = VfsUtil.toUri(url);
        if (uri == null) {
            this.doShowError(IdeBundle.message("error.malformed.url", url), null, null, null);
        } else {
            this.browse(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String extractFiles(String url) {
        try {
            VirtualFile file;
            int sharpPos = url.indexOf(35);
            String anchor = "";
            if (sharpPos != -1) {
                anchor = url.substring(sharpPos);
                url = url.substring(0, sharpPos);
            }
            if ((file = VirtualFileManager.getInstance().findFileByUrl(url)) == null || !(file.getFileSystem() instanceof JarFileSystem)) {
                return null;
            }
            JarFileSystem jarFileSystem = (JarFileSystem)file.getFileSystem();
            VirtualFile jarVirtualFile = jarFileSystem.getVirtualFileForJar(file);
            if (jarVirtualFile == null) {
                return null;
            }
            String targetFilePath = file.getPath();
            String targetFileRelativePath = StringUtil.substringAfter((String)targetFilePath, (String)"!/");
            LOG.assertTrue(targetFileRelativePath != null);
            String jarVirtualFileLocationHash = jarVirtualFile.getName() + Integer.toHexString(jarVirtualFile.getUrl().hashCode());
            final File outputDir = new File(BrowserLauncherAppless.getExtractedFilesDir(), jarVirtualFileLocationHash);
            final String currentTimestamp = String.valueOf(new File(jarVirtualFile.getPath()).lastModified());
            final File timestampFile = new File(outputDir, ".idea.timestamp");
            String previousTimestamp = null;
            if (timestampFile.exists()) {
                previousTimestamp = FileUtilRt.loadFile((File)timestampFile);
            }
            if (!currentTimestamp.equals(previousTimestamp)) {
                final Ref extract = new Ref();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        ConfirmExtractDialog dialog = new ConfirmExtractDialog();
                        if (dialog.isToBeShown()) {
                            dialog.show();
                            extract.set((Object)dialog.isOK());
                        } else {
                            dialog.close(0);
                            extract.set((Object)true);
                        }
                    }
                };
                try {
                    GuiUtils.runOrInvokeAndWait(r);
                }
                catch (InvocationTargetException ignored) {
                    extract.set((Object)false);
                }
                catch (InterruptedException ignored) {
                    extract.set((Object)false);
                }
                if (!((Boolean)extract.get()).booleanValue()) {
                    return null;
                }
                final ZipFile zipFile = jarFileSystem.getJarFile(file).getZipFile();
                if (zipFile == null) {
                    return null;
                }
                ZipEntry entry = zipFile.getEntry(targetFileRelativePath);
                if (entry == null) {
                    return null;
                }
                InputStream is = zipFile.getInputStream(entry);
                try {
                    ZipUtil.extractEntry((ZipEntry)entry, (InputStream)is, (File)outputDir);
                }
                finally {
                    is.close();
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new Task.Backgroundable(null, "Extracting files...", true){

                            @Override
                            public void run(final @NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserLauncherAppless$2$1", "run"));
                                }
                                final int size = zipFile.size();
                                final int[] counter = new int[]{0};
                                try {
                                    class MyFilter
                                    implements FilenameFilter {
                                        private final Set<File> myImportantDirs;
                                        private final boolean myImportantOnly;

                                        MyFilter(boolean importantOnly) {
                                            this.myImportantDirs = new HashSet<File>(Arrays.asList(outputDir, new File(outputDir, "resources")));
                                            this.myImportantOnly = importantOnly;
                                        }

                                        @Override
                                        public boolean accept(@NotNull File dir, @NotNull String name) {
                                            boolean result;
                                            if (dir == null) {
                                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserLauncherAppless$2$1$1MyFilter", "accept"));
                                            }
                                            if (name == null) {
                                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/BrowserLauncherAppless$2$1$1MyFilter", "accept"));
                                            }
                                            indicator.checkCanceled();
                                            boolean bl = result = this.myImportantOnly == this.myImportantDirs.contains(dir);
                                            if (result) {
                                                indicator.setFraction((double)counter[0] / (double)size);
                                                counter[0] = counter[0] + 1;
                                            }
                                            return result;
                                        }
                                    }
                                    ZipUtil.extract((ZipFile)zipFile, (File)outputDir, (FilenameFilter)new MyFilter(true));
                                    ZipUtil.extract((ZipFile)zipFile, (File)outputDir, (FilenameFilter)new MyFilter(false));
                                    FileUtil.writeToFile((File)timestampFile, (byte[])currentTimestamp.getBytes());
                                }
                                catch (IOException ignore) {
                                    // empty catch block
                                }
                            }
                        }.queue();
                    }
                });
            }
            return VfsUtilCore.pathToUrl(FileUtil.toSystemIndependentName((String)new File(outputDir, targetFileRelativePath).getPath())) + anchor;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog("Cannot extract files: " + e.getMessage(), "Error");
            return null;
        }
    }

    private static File getExtractedFilesDir() {
        return new File(PathManager.getSystemPath(), "ExtractedFiles");
    }

    public static void clearExtractedFiles() {
        FileUtil.delete((File)BrowserLauncherAppless.getExtractedFilesDir());
    }

    @Override
    public void browse(@NotNull String url, @Nullable WebBrowser browser) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserLauncherAppless", "browse"));
        }
        this.browse(url, browser, null);
    }

    @Override
    public void browse(@NotNull String url, @Nullable WebBrowser browser, @Nullable Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserLauncherAppless", "browse"));
        }
        if (browser == null) {
            this.openOrBrowse(url, true);
        } else {
            for (UrlOpener urlOpener : (UrlOpener[])UrlOpener.EP_NAME.getExtensions()) {
                if (!urlOpener.openUrl(browser, url, project)) continue;
                return;
            }
        }
    }

    @Override
    public boolean browseUsingPath(@Nullable String url, @Nullable String browserPath, @Nullable WebBrowser browser, @Nullable Project project, @NotNull String[] additionalParameters) {
        if (additionalParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/ide/browsers/BrowserLauncherAppless", "browseUsingPath"));
        }
        return this.doLaunch(url, browserPath == null && browser != null ? PathUtil.toSystemDependentName(browser.getPath()) : browserPath, browser, project, additionalParameters);
    }

    private boolean doLaunch(@Nullable String url, @Nullable String browserPath, @Nullable WebBrowser browser, @Nullable Project project, @NotNull String[] additionalParameters) {
        if (additionalParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/ide/browsers/BrowserLauncherAppless", "doLaunch"));
        }
        if (!this.checkPath(browserPath, browser, project)) {
            return false;
        }
        return this.doLaunch(url, BrowserUtil.getOpenBrowserCommand(browserPath, false), browser, project, additionalParameters);
    }

    @Contract(value="null, _, _ -> false")
    public boolean checkPath(@Nullable String browserPath, @Nullable WebBrowser browser, @Nullable Project project) {
        if (!StringUtil.isEmptyOrSpaces((String)browserPath)) {
            return true;
        }
        this.doShowError(browser == null ? IdeBundle.message("error.please.specify.path.to.web.browser", CommonBundle.settingsActionPath()) : browser.getBrowserNotFoundMessage(), browser, project, IdeBundle.message("title.browser.not.found", new Object[0]));
        return false;
    }

    private boolean doLaunch(@Nullable String url, @NotNull List<String> command, @Nullable WebBrowser browser, @Nullable Project project, String[] additionalParameters) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/BrowserLauncherAppless", "doLaunch"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(command);
        if (url != null) {
            commandLine.addParameter(url);
        }
        BrowserLauncherAppless.addArgs(commandLine, browser == null ? null : browser.getSpecificSettings(), additionalParameters);
        try {
            Process process = commandLine.createProcess();
            this.checkCreatedProcess(browser, project, commandLine, process);
            return true;
        }
        catch (ExecutionException e) {
            this.doShowError(e.getMessage(), browser, project, null);
            return false;
        }
    }

    protected void checkCreatedProcess(WebBrowser browser, Project project, GeneralCommandLine commandLine, Process process) {
    }

    protected void doShowError(String error, WebBrowser browser, Project project, String title) {
        LOG.warn(error);
    }

    private static void addArgs(@NotNull GeneralCommandLine command, @Nullable BrowserSpecificSettings settings, @NotNull String[] additional) {
        List<Object> specific;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserLauncherAppless", "addArgs"));
        }
        if (additional == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/browsers/BrowserLauncherAppless", "addArgs"));
        }
        List<Object> list = specific = settings == null ? Collections.emptyList() : settings.getAdditionalParameters();
        if (specific.size() + additional.length > 0) {
            if (BrowserLauncherAppless.isOpenCommandUsed(command)) {
                if (BrowserUtil.isOpenCommandSupportArgs()) {
                    command.addParameter("--args");
                } else {
                    LOG.warn("'open' command doesn't allow to pass command line arguments so they will be ignored: " + StringUtil.join(specific, (String)", ") + " " + Arrays.toString(additional));
                    return;
                }
            }
            command.addParameters(specific);
            command.addParameters(additional);
        }
    }

    public static boolean isOpenCommandUsed(@NotNull GeneralCommandLine command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/BrowserLauncherAppless", "isOpenCommandUsed"));
        }
        return SystemInfo.isMac && ExecUtil.getOpenCommandPath().equals(command.getExePath());
    }

    private static class ConfirmExtractDialog
    extends OptionsDialog {
        private ConfirmExtractDialog() {
            super(null);
            this.setTitle("Confirmation");
            this.init();
        }

        @Override
        protected boolean isToBeShown() {
            return BrowserLauncherAppless.getGeneralSettingsInstance().isConfirmExtractFiles();
        }

        @Override
        protected void setToBeShown(boolean value, boolean onOk) {
            BrowserLauncherAppless.getGeneralSettingsInstance().setConfirmExtractFiles(value);
        }

        @Override
        protected boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        @Override
        @NotNull
        protected Action[] createActions() {
            this.setOKButtonText(CommonBundle.getYesButtonText());
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/BrowserLauncherAppless$ConfirmExtractDialog", "createActions"));
            }
            return actionArray;
        }

        @Override
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            String message = "The files are inside an archive, do you want them to be extracted?";
            JLabel label = new JLabel(message);
            label.setIconTextGap(10);
            label.setIcon(Messages.getQuestionIcon());
            panel.add((Component)label, "Center");
            panel.add(Box.createVerticalStrut(10), "South");
            return panel;
        }
    }
}

