/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindModel
extends UserDataHolderBase
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.FindModel");
    private final List<FindModelObserver> myObservers = ContainerUtil.createLockFreeCopyOnWriteList();
    private String myStringToFind = "";
    private String myStringToReplace = "";
    private boolean isSearchHighlighters = false;
    private boolean isReplaceState = false;
    private boolean isWholeWordsOnly = false;
    private boolean isInCommentsOnly;
    private boolean isInStringLiteralsOnly;
    private boolean isFromCursor = true;
    private boolean isForward = true;
    private boolean isGlobal = true;
    private boolean isRegularExpressions = false;
    private boolean isCaseSensitive = false;
    private boolean isMultipleFiles = false;
    private boolean isPromptOnReplace = true;
    private boolean isReplaceAll = false;
    private boolean isOpenNewTab = false;
    private boolean isOpenInNewTabEnabled = false;
    private boolean isOpenNewTabVisible = false;
    private boolean isProjectScope = true;
    private boolean isFindAll = false;
    private boolean isFindAllEnabled = false;
    private String moduleName;
    private String directoryName = null;
    private boolean isWithSubdirectories = true;
    private String fileFilter;
    private String customScopeName;
    private SearchScope customScope;
    private boolean isCustomScope = false;
    private boolean isMultiline = false;
    private boolean isPreserveCase = false;
    private static final Pattern NO_PATTERN = Pattern.compile("");
    private Pattern myPattern = NO_PATTERN;

    public static void initStringToFindNoMultiline(FindModel findModel, String s) {
        if (!StringUtil.isEmpty((String)s)) {
            if (!s.contains("\r") && !s.contains("\n")) {
                findModel.setStringToFind(s);
            } else {
                findModel.setStringToFind(StringUtil.escapeToRegexp((String)s));
                findModel.setRegularExpressions(true);
            }
        }
    }

    public void addObserver(FindModelObserver observer) {
        this.myObservers.add(observer);
    }

    public void removeObserver(FindModelObserver observer) {
        this.myObservers.remove(observer);
    }

    private void notifyObservers() {
        for (FindModelObserver observer : this.myObservers) {
            observer.findModelChanged(this);
        }
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public void setMultiline(boolean multiline) {
        if (multiline != this.isMultiline) {
            if (!multiline) {
                FindModel.initStringToFindNoMultiline(this, this.getStringToFind());
            } else {
                this.setRegularExpressions(false);
            }
            this.isMultiline = multiline;
            this.notifyObservers();
        }
    }

    public boolean isPreserveCase() {
        return this.isPreserveCase;
    }

    public void setPreserveCase(boolean preserveCase) {
        boolean changed = this.isPreserveCase != preserveCase;
        this.isPreserveCase = preserveCase;
        if (changed) {
            this.notifyObservers();
        }
    }

    public void copyFrom(FindModel model) {
        this.myStringToFind = model.myStringToFind;
        this.myStringToReplace = model.myStringToReplace;
        this.isReplaceState = model.isReplaceState;
        this.isWholeWordsOnly = model.isWholeWordsOnly;
        this.isFromCursor = model.isFromCursor;
        this.isForward = model.isForward;
        this.isGlobal = model.isGlobal;
        this.isRegularExpressions = model.isRegularExpressions;
        this.isCaseSensitive = model.isCaseSensitive;
        this.isMultipleFiles = model.isMultipleFiles;
        this.isPromptOnReplace = model.isPromptOnReplace;
        this.isReplaceAll = model.isReplaceAll;
        this.isOpenNewTab = model.isOpenNewTab;
        this.isOpenInNewTabEnabled = model.isOpenInNewTabEnabled;
        this.isOpenNewTabVisible = model.isOpenNewTabVisible;
        this.isProjectScope = model.isProjectScope;
        this.directoryName = model.directoryName;
        this.isWithSubdirectories = model.isWithSubdirectories;
        this.isPreserveCase = model.isPreserveCase;
        this.fileFilter = model.fileFilter;
        this.moduleName = model.moduleName;
        this.customScopeName = model.customScopeName;
        this.customScope = model.customScope;
        this.isCustomScope = model.isCustomScope;
        this.isFindAll = model.isFindAll;
        this.isInCommentsOnly = model.isInCommentsOnly;
        this.isInStringLiteralsOnly = model.isInStringLiteralsOnly;
        this.isMultiline = model.isMultiline;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindModel findModel = (FindModel)o;
        if (this.isCaseSensitive != findModel.isCaseSensitive) {
            return false;
        }
        if (this.isCustomScope != findModel.isCustomScope) {
            return false;
        }
        if (this.isFindAll != findModel.isFindAll) {
            return false;
        }
        if (this.isFindAllEnabled != findModel.isFindAllEnabled) {
            return false;
        }
        if (this.isForward != findModel.isForward) {
            return false;
        }
        if (this.isFromCursor != findModel.isFromCursor) {
            return false;
        }
        if (this.isGlobal != findModel.isGlobal) {
            return false;
        }
        if (this.isInCommentsOnly != findModel.isInCommentsOnly) {
            return false;
        }
        if (this.isInStringLiteralsOnly != findModel.isInStringLiteralsOnly) {
            return false;
        }
        if (this.isMultiline != findModel.isMultiline) {
            return false;
        }
        if (this.isMultipleFiles != findModel.isMultipleFiles) {
            return false;
        }
        if (this.isOpenInNewTabEnabled != findModel.isOpenInNewTabEnabled) {
            return false;
        }
        if (this.isOpenNewTab != findModel.isOpenNewTab) {
            return false;
        }
        if (this.isOpenNewTabVisible != findModel.isOpenNewTabVisible) {
            return false;
        }
        if (this.isPreserveCase != findModel.isPreserveCase) {
            return false;
        }
        if (this.isProjectScope != findModel.isProjectScope) {
            return false;
        }
        if (this.isPromptOnReplace != findModel.isPromptOnReplace) {
            return false;
        }
        if (this.isRegularExpressions != findModel.isRegularExpressions) {
            return false;
        }
        if (this.isReplaceAll != findModel.isReplaceAll) {
            return false;
        }
        if (this.isReplaceState != findModel.isReplaceState) {
            return false;
        }
        if (this.isSearchHighlighters != findModel.isSearchHighlighters) {
            return false;
        }
        if (this.isWholeWordsOnly != findModel.isWholeWordsOnly) {
            return false;
        }
        if (this.isWithSubdirectories != findModel.isWithSubdirectories) {
            return false;
        }
        if (this.customScope != null ? !this.customScope.equals(findModel.customScope) : findModel.customScope != null) {
            return false;
        }
        if (this.customScopeName != null ? !this.customScopeName.equals(findModel.customScopeName) : findModel.customScopeName != null) {
            return false;
        }
        if (this.directoryName != null ? !this.directoryName.equals(findModel.directoryName) : findModel.directoryName != null) {
            return false;
        }
        if (this.fileFilter != null ? !this.fileFilter.equals(findModel.fileFilter) : findModel.fileFilter != null) {
            return false;
        }
        if (this.moduleName != null ? !this.moduleName.equals(findModel.moduleName) : findModel.moduleName != null) {
            return false;
        }
        if (this.myStringToFind != null ? !this.myStringToFind.equals(findModel.myStringToFind) : findModel.myStringToFind != null) {
            return false;
        }
        return !(this.myStringToReplace != null ? !this.myStringToReplace.equals(findModel.myStringToReplace) : findModel.myStringToReplace != null);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.myStringToFind != null ? this.myStringToFind.hashCode() : 0);
        result = 31 * result + (this.myStringToReplace != null ? this.myStringToReplace.hashCode() : 0);
        result = 31 * result + (this.isSearchHighlighters ? 1 : 0);
        result = 31 * result + (this.isReplaceState ? 1 : 0);
        result = 31 * result + (this.isWholeWordsOnly ? 1 : 0);
        result = 31 * result + (this.isInCommentsOnly ? 1 : 0);
        result = 31 * result + (this.isInStringLiteralsOnly ? 1 : 0);
        result = 31 * result + (this.isFromCursor ? 1 : 0);
        result = 31 * result + (this.isForward ? 1 : 0);
        result = 31 * result + (this.isGlobal ? 1 : 0);
        result = 31 * result + (this.isRegularExpressions ? 1 : 0);
        result = 31 * result + (this.isCaseSensitive ? 1 : 0);
        result = 31 * result + (this.isMultipleFiles ? 1 : 0);
        result = 31 * result + (this.isPromptOnReplace ? 1 : 0);
        result = 31 * result + (this.isReplaceAll ? 1 : 0);
        result = 31 * result + (this.isOpenNewTab ? 1 : 0);
        result = 31 * result + (this.isOpenInNewTabEnabled ? 1 : 0);
        result = 31 * result + (this.isOpenNewTabVisible ? 1 : 0);
        result = 31 * result + (this.isProjectScope ? 1 : 0);
        result = 31 * result + (this.isFindAll ? 1 : 0);
        result = 31 * result + (this.isFindAllEnabled ? 1 : 0);
        result = 31 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result = 31 * result + (this.directoryName != null ? this.directoryName.hashCode() : 0);
        result = 31 * result + (this.isWithSubdirectories ? 1 : 0);
        result = 31 * result + (this.fileFilter != null ? this.fileFilter.hashCode() : 0);
        result = 31 * result + (this.customScopeName != null ? this.customScopeName.hashCode() : 0);
        result = 31 * result + (this.customScope != null ? this.customScope.hashCode() : 0);
        result = 31 * result + (this.isCustomScope ? 1 : 0);
        result = 31 * result + (this.isMultiline ? 1 : 0);
        result = 31 * result + (this.isPreserveCase ? 1 : 0);
        result = 31 * result + (this.myPattern != null ? this.myPattern.hashCode() : 0);
        return result;
    }

    @NotNull
    public String getStringToFind() {
        String string = this.myStringToFind;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/FindModel", "getStringToFind"));
        }
        return string;
    }

    public void setStringToFind(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/FindModel", "setStringToFind"));
        }
        boolean changed = !StringUtil.equals((CharSequence)s, (CharSequence)this.myStringToFind);
        this.myStringToFind = s;
        this.myPattern = NO_PATTERN;
        if (changed) {
            this.notifyObservers();
        }
    }

    @NotNull
    public String getStringToReplace() {
        String string = this.myStringToReplace;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/FindModel", "getStringToReplace"));
        }
        return string;
    }

    public void setStringToReplace(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/find/FindModel", "setStringToReplace"));
        }
        boolean changed = !StringUtil.equals((CharSequence)s, (CharSequence)this.myStringToReplace);
        this.myStringToReplace = s;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isReplaceState() {
        return this.isReplaceState;
    }

    public void setReplaceState(boolean val) {
        boolean changed = val != this.isReplaceState;
        this.isReplaceState = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isFromCursor() {
        return this.isFromCursor;
    }

    public void setFromCursor(boolean val) {
        boolean changed = val != this.isFromCursor;
        this.isFromCursor = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean val) {
        boolean changed = val != this.isForward;
        this.isForward = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isRegularExpressions() {
        return this.isRegularExpressions;
    }

    public void setRegularExpressions(boolean val) {
        boolean changed = val != this.isRegularExpressions;
        this.isRegularExpressions = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean val) {
        boolean changed = val != this.isCaseSensitive;
        this.isCaseSensitive = val;
        if (changed) {
            this.myPattern = NO_PATTERN;
            this.notifyObservers();
        }
    }

    public boolean isMultipleFiles() {
        return this.isMultipleFiles;
    }

    public void setMultipleFiles(boolean val) {
        boolean changed = val != this.isMultipleFiles;
        this.isMultipleFiles = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isPromptOnReplace() {
        return this.isPromptOnReplace;
    }

    public void setPromptOnReplace(boolean val) {
        boolean changed = val != this.isPromptOnReplace;
        this.isPromptOnReplace = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isWholeWordsOnly() {
        return this.isWholeWordsOnly;
    }

    public void setWholeWordsOnly(boolean isWholeWordsOnly) {
        boolean changed = isWholeWordsOnly != this.isWholeWordsOnly;
        this.isWholeWordsOnly = isWholeWordsOnly;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        boolean changed = this.isGlobal != isGlobal;
        this.isGlobal = isGlobal;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isReplaceAll() {
        return this.isReplaceAll;
    }

    public void setReplaceAll(boolean replaceAll) {
        boolean changed = this.isReplaceAll != replaceAll;
        this.isReplaceAll = replaceAll;
        this.notifyObservers();
    }

    public boolean isOpenInNewTab() {
        return this.isOpenNewTab;
    }

    public void setOpenInNewTab(boolean showInNewTab) {
        boolean changed = showInNewTab != this.isOpenNewTab;
        this.isOpenNewTab = showInNewTab;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isOpenInNewTabEnabled() {
        return this.isOpenInNewTabEnabled;
    }

    public void setOpenInNewTabEnabled(boolean showInNewTabEnabled) {
        boolean changed = this.isOpenInNewTabEnabled != showInNewTabEnabled;
        this.isOpenInNewTabEnabled = showInNewTabEnabled;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isOpenInNewTabVisible() {
        return this.isOpenNewTabVisible;
    }

    public void setOpenInNewTabVisible(boolean showInNewTabVisible) {
        boolean changed = showInNewTabVisible != this.isOpenNewTabVisible;
        this.isOpenNewTabVisible = showInNewTabVisible;
        if (changed) {
            this.notifyObservers();
        }
    }

    @Nullable
    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        boolean changed = !StringUtil.equals((CharSequence)directoryName, (CharSequence)directoryName);
        this.directoryName = directoryName;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isWithSubdirectories() {
        return this.isWithSubdirectories;
    }

    public void setWithSubdirectories(boolean withSubdirectories) {
        boolean changed = withSubdirectories != this.isWithSubdirectories;
        this.isWithSubdirectories = withSubdirectories;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isProjectScope() {
        return this.isProjectScope;
    }

    public void setProjectScope(boolean projectScope) {
        boolean changed = projectScope != this.isProjectScope;
        this.isProjectScope = projectScope;
        if (changed) {
            this.notifyObservers();
        }
    }

    public Object clone() {
        return super.clone();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("--- FIND MODEL ---\n");
        buffer.append("myStringToFind =").append(this.myStringToFind).append("\n");
        buffer.append("myStringToReplace =").append(this.myStringToReplace).append("\n");
        buffer.append("isReplaceState =").append(this.isReplaceState).append("\n");
        buffer.append("isWholeWordsOnly =").append(this.isWholeWordsOnly).append("\n");
        buffer.append("isInStringLiterals =").append(this.isInStringLiteralsOnly).append("\n");
        buffer.append("isInComments =").append(this.isInCommentsOnly).append("\n");
        buffer.append("isFromCursor =").append(this.isFromCursor).append("\n");
        buffer.append("isForward =").append(this.isForward).append("\n");
        buffer.append("isGlobal =").append(this.isGlobal).append("\n");
        buffer.append("isRegularExpressions =").append(this.isRegularExpressions).append("\n");
        buffer.append("isCaseSensitive =").append(this.isCaseSensitive).append("\n");
        buffer.append("isMultipleFiles =").append(this.isMultipleFiles).append("\n");
        buffer.append("isPromptOnReplace =").append(this.isPromptOnReplace).append("\n");
        buffer.append("isReplaceAll =").append(this.isReplaceAll).append("\n");
        buffer.append("isOpenNewTab =").append(this.isOpenNewTab).append("\n");
        buffer.append("isOpenInNewTabEnabled =").append(this.isOpenInNewTabEnabled).append("\n");
        buffer.append("isOpenNewTabVisible =").append(this.isOpenNewTabVisible).append("\n");
        buffer.append("isProjectScope =").append(this.isProjectScope).append("\n");
        buffer.append("directoryName =").append(this.directoryName).append("\n");
        buffer.append("isWithSubdirectories =").append(this.isWithSubdirectories).append("\n");
        buffer.append("fileFilter =").append(this.fileFilter).append("\n");
        buffer.append("moduleName =").append(this.moduleName).append("\n");
        buffer.append("customScopeName =").append(this.customScopeName).append("\n");
        return buffer.toString();
    }

    public boolean searchHighlighters() {
        return this.isSearchHighlighters;
    }

    public void setSearchHighlighters(boolean search) {
        boolean changed = search != this.isSearchHighlighters;
        this.isSearchHighlighters = search;
        if (changed) {
            this.notifyObservers();
        }
    }

    public String getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(String fileFilter) {
        boolean changed = !StringUtil.equals((CharSequence)fileFilter, (CharSequence)this.fileFilter);
        this.fileFilter = fileFilter;
        if (changed) {
            this.notifyObservers();
        }
    }

    @Nullable
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        boolean changed = !StringUtil.equals((CharSequence)moduleName, (CharSequence)this.moduleName);
        this.moduleName = moduleName;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isFindAll() {
        return this.isFindAll;
    }

    public void setFindAll(boolean findAll) {
        boolean changed = this.isFindAll != findAll;
        this.isFindAll = findAll;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isFindAllEnabled() {
        return this.isFindAllEnabled;
    }

    public void setFindAllEnabled(boolean findAllEnabled) {
        boolean changed = this.isFindAllEnabled != findAllEnabled;
        this.isFindAllEnabled = findAllEnabled;
        if (changed) {
            this.notifyObservers();
        }
    }

    public String getCustomScopeName() {
        return this.customScopeName;
    }

    public void setCustomScopeName(String customScopeName) {
        boolean changed = !StringUtil.equals((CharSequence)customScopeName, (CharSequence)this.customScopeName);
        this.customScopeName = customScopeName;
        if (changed) {
            this.notifyObservers();
        }
    }

    public SearchScope getCustomScope() {
        return this.customScope;
    }

    public void setCustomScope(SearchScope customScope) {
        boolean changed = this.customScope != null ? this.customScope.equals(customScope) : customScope != null;
        this.customScope = customScope;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isCustomScope() {
        return this.isCustomScope;
    }

    public void setCustomScope(boolean customScope) {
        boolean changed = this.isCustomScope != customScope;
        this.isCustomScope = customScope;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isInStringLiteralsOnly() {
        return this.isInStringLiteralsOnly;
    }

    public void setInStringLiteralsOnly(boolean inStringLiteralsOnly) {
        boolean changed = this.isInStringLiteralsOnly != inStringLiteralsOnly;
        this.isInStringLiteralsOnly = inStringLiteralsOnly;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isInCommentsOnly() {
        return this.isInCommentsOnly;
    }

    public void setInCommentsOnly(boolean inCommentsOnly) {
        boolean changed = this.isInCommentsOnly != inCommentsOnly;
        this.isInCommentsOnly = inCommentsOnly;
        if (changed) {
            this.notifyObservers();
        }
    }

    public Pattern compileRegExp() {
        String toFind = this.getStringToFind();
        Pattern pattern = this.myPattern;
        if (pattern == NO_PATTERN) {
            try {
                this.myPattern = pattern = Pattern.compile(toFind, this.isCaseSensitive() ? 8 : 10);
            }
            catch (PatternSyntaxException e) {
                LOG.error("Regexp:'" + toFind + "'", (Throwable)e);
                this.myPattern = null;
                return null;
            }
        }
        return pattern;
    }

    public static interface FindModelObserver {
        public void findModelChanged(FindModel var1);
    }
}

