/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecUtil {
    private static final NotNullLazyValue<Boolean> hasGkSudo = new NotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl = new File("/usr/bin/gksudo").canExecute();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil$1", "compute"));
            }
            return bl;
        }
    };
    private static final NotNullLazyValue<Boolean> hasKdeSudo = new NotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl = new File("/usr/bin/kdesudo").canExecute();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil$2", "compute"));
            }
            return bl;
        }
    };
    private static final NotNullLazyValue<Boolean> hasPkExec = new NotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl = new File("/usr/bin/pkexec").canExecute();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil$3", "compute"));
            }
            return bl;
        }
    };
    private static final NotNullLazyValue<Boolean> hasGnomeTerminal = new NotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl = new File("/usr/bin/gnome-terminal").canExecute();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil$4", "compute"));
            }
            return bl;
        }
    };
    private static final NotNullLazyValue<Boolean> hasKdeTerminal = new NotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl = new File("/usr/bin/konsole").canExecute();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil$5", "compute"));
            }
            return bl;
        }
    };
    private static final NotNullLazyValue<Boolean> hasXTerm = new NotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            Boolean bl = new File("/usr/bin/xterm").canExecute();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil$6", "compute"));
            }
            return bl;
        }
    };

    private ExecUtil() {
    }

    public static int execAndGetResult(String ... command) throws ExecutionException, InterruptedException {
        assert (command != null && command.length > 0);
        return ExecUtil.execAndGetResult(Arrays.asList(command));
    }

    public static int execAndGetResult(@NotNull List<String> command) throws ExecutionException, InterruptedException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "execAndGetResult"));
        }
        assert (command.size() > 0);
        GeneralCommandLine commandLine = new GeneralCommandLine(command);
        Process process = commandLine.createProcess();
        return process.waitFor();
    }

    @NotNull
    public static String loadTemplate(@NotNull ClassLoader loader, @NotNull String templateName, @Nullable Map<String, String> variables) throws IOException {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "loadTemplate"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/util/ExecUtil", "loadTemplate"));
        }
        InputStream stream = loader.getResourceAsStream(templateName);
        if (stream == null) {
            throw new IOException("Template '" + templateName + "' not found by " + loader);
        }
        String template = FileUtil.loadTextAndClose((InputStream)stream);
        if (variables == null || variables.size() == 0) {
            String string = template;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "loadTemplate"));
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder(template);
        for (Map.Entry<String, String> var : variables.entrySet()) {
            String name = var.getKey();
            int pos = buffer.indexOf(name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), var.getValue());
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "loadTemplate"));
        }
        return string;
    }

    @NotNull
    public static File createTempExecutableScript(@NotNull String prefix, @NotNull String suffix, @NotNull String source) throws IOException, ExecutionException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "createTempExecutableScript"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/util/ExecUtil", "createTempExecutableScript"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/util/ExecUtil", "createTempExecutableScript"));
        }
        File tempDir = new File(PathManager.getTempPath());
        File tempFile = FileUtil.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)true);
        FileUtil.writeToFile((File)tempFile, (String)source);
        if (!tempFile.setExecutable(true, true)) {
            throw new ExecutionException("Failed to make temp file executable: " + tempFile);
        }
        File file = tempFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "createTempExecutableScript"));
        }
        return file;
    }

    @NotNull
    public static String getOsascriptPath() {
        if ("/usr/bin/osascript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "getOsascriptPath"));
        }
        return "/usr/bin/osascript";
    }

    @NotNull
    public static String getOpenCommandPath() {
        if ("/usr/bin/open" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "getOpenCommandPath"));
        }
        return "/usr/bin/open";
    }

    @NotNull
    public static String getWindowsShellName() {
        String string = SystemInfo.isWin2kOrNewer ? "cmd.exe" : "command.com";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "getWindowsShellName"));
        }
        return string;
    }

    @NotNull
    public static ProcessOutput execAndGetOutput(@NotNull List<String> command, @Nullable String workDir) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "execAndGetOutput"));
        }
        assert (command.size() > 0);
        GeneralCommandLine commandLine = new GeneralCommandLine(command);
        commandLine.setWorkDirectory(workDir);
        Process process = commandLine.createProcess();
        CapturingProcessHandler processHandler = new CapturingProcessHandler(process);
        ProcessOutput processOutput = processHandler.runProcess();
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "execAndGetOutput"));
        }
        return processOutput;
    }

    @Nullable
    public static String execAndReadLine(String ... command) {
        return ExecUtil.execAndReadLine(null, command);
    }

    @Nullable
    public static String execAndReadLine(@Nullable Charset charset, String ... command) {
        try {
            return ExecUtil.readFirstLine(new GeneralCommandLine(command).createProcess().getInputStream(), charset);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readFirstLine(@NotNull InputStream inputStream, @Nullable Charset charset) {
        String string;
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "readFirstLine"));
        }
        BufferedReader reader = new BufferedReader(charset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, charset));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ignored) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    @NotNull
    public static ProcessOutput sudoAndGetOutput(@NotNull List<String> command, @NotNull String prompt, @Nullable String workDir) throws IOException, ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
        }
        if (prompt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
        }
        if (SystemInfo.isMac) {
            String escapedCommandLine = StringUtil.join(command, (Function)new Function<String, String>(){

                public String fun(String s) {
                    return ExecUtil.escapeAppleScriptArgument(s);
                }
            }, (String)" & \" \" & ");
            String escapedScript = "do shell script " + escapedCommandLine + " with administrator privileges";
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(Arrays.asList(ExecUtil.getOsascriptPath(), "-e", escapedScript), workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        if ("root".equals(System.getenv("USER"))) {
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(command, workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        if (((Boolean)hasGkSudo.getValue()).booleanValue()) {
            ArrayList<String> sudoCommand = new ArrayList<String>();
            sudoCommand.addAll(Arrays.asList("gksudo", "--message", prompt, "--"));
            sudoCommand.addAll(command);
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(sudoCommand, workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        if (((Boolean)hasKdeSudo.getValue()).booleanValue()) {
            ArrayList<String> sudoCommand = new ArrayList<String>();
            sudoCommand.addAll(Arrays.asList("kdesudo", "--comment", prompt, "--"));
            sudoCommand.addAll(command);
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(sudoCommand, workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        if (((Boolean)hasPkExec.getValue()).booleanValue()) {
            ArrayList<String> sudoCommand = new ArrayList<String>();
            sudoCommand.add("pkexec");
            sudoCommand.addAll(command);
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(sudoCommand, workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        if (SystemInfo.isUnix && ExecUtil.hasTerminalApp()) {
            String escapedCommandLine = StringUtil.join(command, (Function)new Function<String, String>(){

                public String fun(String s) {
                    return ExecUtil.escapeUnixShellArgument(s);
                }
            }, (String)" ");
            File script = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho " + ExecUtil.escapeUnixShellArgument(prompt) + "\n" + "echo\n" + "sudo -- " + escapedCommandLine + "\n" + "STATUS=$?\n" + "echo\n" + "read -p \"Press Enter to close this window...\" TEMP\n" + "exit $STATUS\n");
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(ExecUtil.getTerminalCommand("Install", script.getAbsolutePath()), workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        throw new UnsupportedSystemException();
    }

    @NotNull
    private static String escapeAppleScriptArgument(@NotNull String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "escapeAppleScriptArgument"));
        }
        String string = "quoted form of \"" + arg.replace("\"", "\\\"") + "\"";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "escapeAppleScriptArgument"));
        }
        return string;
    }

    @NotNull
    private static String escapeUnixShellArgument(@NotNull String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "escapeUnixShellArgument"));
        }
        String string = "'" + arg.replace("'", "'\"'\"'") + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "escapeUnixShellArgument"));
        }
        return string;
    }

    public static ProcessOutput sudoAndGetOutput(@NotNull String scriptPath, @NotNull String prompt) throws IOException, ExecutionException {
        if (scriptPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
        }
        if (prompt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
        }
        return ExecUtil.sudoAndGetOutput(scriptPath, prompt, null);
    }

    @NotNull
    public static ProcessOutput sudoAndGetOutput(@NotNull String scriptPath, @NotNull String prompt, @Nullable String workDir) throws IOException, ExecutionException {
        if (scriptPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
        }
        if (prompt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
        }
        if (SystemInfo.isMac) {
            String script = "do shell script \"" + scriptPath + "\" with administrator privileges";
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(Arrays.asList(ExecUtil.getOsascriptPath(), "-e", script), workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        if ("root".equals(System.getenv("USER"))) {
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(Collections.singletonList(scriptPath), workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        if (((Boolean)hasKdeSudo.getValue()).booleanValue()) {
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(Arrays.asList("kdesudo", "--comment", prompt, scriptPath), workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        if (((Boolean)hasGkSudo.getValue()).booleanValue()) {
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(Arrays.asList("gksudo", "--message", prompt, scriptPath), workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        if (((Boolean)hasPkExec.getValue()).booleanValue()) {
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(Arrays.asList("pkexec", scriptPath), workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        if (SystemInfo.isUnix && ExecUtil.hasTerminalApp()) {
            File sudo = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho \"" + prompt + "\"\n" + "echo\n" + "sudo " + scriptPath + "\n" + "STATUS=$?\n" + "echo\n" + "read -p \"Press Enter to close this window...\" TEMP\n" + "exit $STATUS\n");
            ProcessOutput processOutput = ExecUtil.execAndGetOutput(ExecUtil.getTerminalCommand("Install", sudo.getAbsolutePath()), workDir);
            if (processOutput == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "sudoAndGetOutput"));
            }
            return processOutput;
        }
        throw new UnsupportedSystemException();
    }

    public static int sudoAndGetResult(@NotNull String scriptPath, @NotNull String prompt) throws IOException, ExecutionException {
        if (scriptPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/util/ExecUtil", "sudoAndGetResult"));
        }
        if (prompt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/util/ExecUtil", "sudoAndGetResult"));
        }
        return ExecUtil.sudoAndGetOutput(scriptPath, prompt, null).getExitCode();
    }

    public static boolean hasTerminalApp() {
        return SystemInfo.isWindows || SystemInfo.isMac || (Boolean)hasKdeTerminal.getValue() != false || (Boolean)hasGnomeTerminal.getValue() != false || (Boolean)hasXTerm.getValue() != false;
    }

    @NotNull
    public static List<String> getTerminalCommand(@Nullable String title, @NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/util/ExecUtil", "getTerminalCommand"));
        }
        if (SystemInfo.isWindows) {
            title = title != null ? title.replace("\"", "'") : "";
            List<String> list = Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote(title), command);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "getTerminalCommand"));
            }
            return list;
        }
        if (SystemInfo.isMac) {
            List<String> list = Arrays.asList(ExecUtil.getOpenCommandPath(), "-a", "Terminal", command);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "getTerminalCommand"));
            }
            return list;
        }
        if (((Boolean)hasKdeTerminal.getValue()).booleanValue()) {
            List<String> list = Arrays.asList("/usr/bin/konsole", "-e", command);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "getTerminalCommand"));
            }
            return list;
        }
        if (((Boolean)hasGnomeTerminal.getValue()).booleanValue()) {
            List<String> list = title != null ? Arrays.asList("/usr/bin/gnome-terminal", "-t", title, "-x", command) : Arrays.asList("/usr/bin/gnome-terminal", "-x", command);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "getTerminalCommand"));
            }
            return list;
        }
        if (((Boolean)hasXTerm.getValue()).booleanValue()) {
            List<String> list = title != null ? Arrays.asList("/usr/bin/xterm", "-T", title, "-e", command) : Arrays.asList("/usr/bin/xterm", "-e", command);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ExecUtil", "getTerminalCommand"));
            }
            return list;
        }
        throw new UnsupportedSystemException();
    }

    public static class UnsupportedSystemException
    extends UnsupportedOperationException {
        public UnsupportedSystemException() {
            super("Unsupported OS/desktop: " + SystemInfo.OS_NAME + '/' + SystemInfo.SUN_DESKTOP);
        }
    }
}

