/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class ExecutionUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.runners.ExecutionUtil");
    private static final NotificationGroup ourNotificationGroup = NotificationGroup.logOnlyGroup("Execution");

    private ExecutionUtil() {
    }

    public static void handleExecutionError(@NotNull Project project, @NotNull String toolWindowId, @NotNull RunProfile runProfile, @NotNull ExecutionException e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        ExecutionUtil.handleExecutionError(project, toolWindowId, runProfile.getName(), e);
    }

    public static void handleExecutionError(final @NotNull Project project, final @NotNull String toolWindowId, @NotNull String taskName, @NotNull ExecutionException e) {
        String commandLineString;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/runners/ExecutionUtil", "handleExecutionError"));
        }
        if (e instanceof RunCanceledByUserException) {
            return;
        }
        LOG.debug((Throwable)e);
        String description = e.getMessage();
        HyperlinkListener listener = null;
        if (description == null) {
            LOG.warn("Execution error without description", (Throwable)e);
            description = "Unknown error";
        }
        if ((description.contains("87") || description.contains("111") || description.contains("206")) && e instanceof ProcessNotCreatedException && !PropertiesComponent.getInstance(project).isTrueValue("dynamic.classpath") && (commandLineString = ((ProcessNotCreatedException)e).getCommandLine().getCommandLineString()).length() > 32768) {
            description = "Command line is too long. In order to reduce its length classpath file can be used.<br>Would you like to enable classpath file mode for all run configurations of your project?<br><a href=\"\">Enable</a>";
            listener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    PropertiesComponent.getInstance(project).setValue("dynamic.classpath", "true");
                }
            };
        }
        final String title = ExecutionBundle.message("error.running.configuration.message", taskName);
        final String fullMessage = title + ":<br>" + description;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(fullMessage);
        }
        if (listener == null && e instanceof HyperlinkListener) {
            listener = (HyperlinkListener)((Object)e);
        }
        final HyperlinkListener finalListener = listener;
        final String finalDescription = description;
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ToolWindowManager.getInstance(project).notifyByBalloon(toolWindowId, MessageType.ERROR, fullMessage, null, finalListener);
                NotificationListener notificationListener = (NotificationListener)ObjectUtils.tryCast((Object)finalListener, NotificationListener.class);
                ourNotificationGroup.createNotification(title, finalDescription, NotificationType.ERROR, notificationListener).notify(project);
            }
        });
    }
}

