/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnsiEscapeDecoder {
    private static final char TEXT_ATTRS_PREFIX_CH = '\u001b';
    private static final String TEXT_ATTRS_PREFIX = Character.toString('\u001b') + "[";
    private static final String TEXT_ATTRS_PATTERN = "m\u001b\\[";
    private Key myCurrentColor;

    public void escapeText(String text, Key outputType, ColoredTextAcceptor textAcceptor) {
        int macroPos;
        ArrayList textChunks = ContainerUtil.newArrayList();
        int pos = 0;
        while ((macroPos = text.indexOf(TEXT_ATTRS_PREFIX, pos)) >= 0) {
            int macroEndPos;
            if (pos != macroPos) {
                textChunks.add(Pair.create((Object)text.substring(pos, macroPos), (Object)this.getCurrentOutputAttributes(outputType)));
            }
            if ((macroEndPos = AnsiEscapeDecoder.getEndMacroPos(text, macroPos)) < 0) break;
            String colorAttribute = text.substring(macroPos, macroEndPos).replaceAll(TEXT_ATTRS_PATTERN, ";");
            this.myCurrentColor = ColoredOutputTypeRegistry.getInstance().getOutputKey(colorAttribute);
            pos = macroEndPos;
        }
        if (pos < text.length()) {
            textChunks.add(Pair.create((Object)text.substring(pos), (Object)this.getCurrentOutputAttributes(outputType)));
        }
        if (textAcceptor instanceof ColoredChunksAcceptor) {
            ((ColoredChunksAcceptor)textAcceptor).coloredChunksAvailable(textChunks);
        } else {
            this.coloredTextAvailable(textChunks, textAcceptor);
        }
    }

    private static int getEndMacroPos(String text, int macroPos) {
        int endMacroPos = text.indexOf(109, macroPos);
        while (endMacroPos >= 0 && (macroPos = text.indexOf(TEXT_ATTRS_PREFIX, ++endMacroPos)) == endMacroPos) {
            endMacroPos = text.indexOf(109, macroPos);
        }
        return endMacroPos;
    }

    protected Key getCurrentOutputAttributes(Key outputType) {
        if (outputType == ProcessOutputTypes.STDERR || outputType == ProcessOutputTypes.SYSTEM) {
            return outputType;
        }
        return this.myCurrentColor != null ? this.myCurrentColor : outputType;
    }

    public void coloredTextAvailable(@NotNull List<Pair<String, Key>> textChunks, ColoredTextAcceptor textAcceptor) {
        if (textChunks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/process/AnsiEscapeDecoder", "coloredTextAvailable"));
        }
        for (Pair<String, Key> textChunk : textChunks) {
            textAcceptor.coloredTextAvailable((String)textChunk.getFirst(), (Key)textChunk.getSecond());
        }
    }

    public static interface ColoredTextAcceptor {
        public void coloredTextAvailable(String var1, Key var2);
    }

    public static interface ColoredChunksAcceptor
    extends ColoredTextAcceptor {
        public void coloredChunksAvailable(List<Pair<String, Key>> var1);
    }
}

