/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class UrlFilter
implements Filter {
    private static final Pattern URL_PATTERN = Pattern.compile("\\bhttps?://[-A-Za-z0-9+&@#/%?=~_|!:,.;]*[-A-Za-z0-9+&@#/%=~_|]");

    @Override
    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        int textStartOffset = entireLength - line.length();
        Matcher m = URL_PATTERN.matcher(line);
        if (m.find()) {
            return new Filter.Result(textStartOffset + m.start(), textStartOffset + m.end(), new BrowserHyperlinkInfo(m.group()));
        }
        return null;
    }
}

