/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public final class OpenFileHyperlinkInfo
implements FileHyperlinkInfo {
    private static final int UNDEFINED_OFFSET = -1;
    private final Project myProject;
    private final VirtualFile myFile;
    private final int myDocumentLine;
    private final int myDocumentColumn;

    public OpenFileHyperlinkInfo(@NotNull OpenFileDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        this(descriptor.getProject(), descriptor.getFile(), descriptor.getLine(), descriptor.getColumn());
    }

    public OpenFileHyperlinkInfo(@NotNull Project project, @NotNull VirtualFile file, int documentLine, int documentColumn) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        this.myProject = project;
        this.myFile = file;
        this.myDocumentLine = documentLine;
        this.myDocumentColumn = documentColumn;
    }

    public OpenFileHyperlinkInfo(@NotNull Project project, @NotNull VirtualFile file, int line) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        this(project, file, line, 0);
    }

    @Override
    public OpenFileDescriptor getDescriptor() {
        if (!this.myFile.isValid()) {
            return null;
        }
        int offset = OpenFileHyperlinkInfo.calculateOffset(this.myFile, this.myDocumentLine, this.myDocumentColumn);
        if (offset != -1) {
            return new OpenFileDescriptor(this.myProject, this.myFile, offset);
        }
        return new OpenFileDescriptor(this.myProject, this.myFile, this.myDocumentLine, this.myDocumentColumn);
    }

    @Override
    public void navigate(final Project project) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                OpenFileDescriptor descriptor = OpenFileHyperlinkInfo.this.getDescriptor();
                if (descriptor != null) {
                    FileEditorManager.getInstance(project).openTextEditor(descriptor, true);
                }
            }
        });
    }

    private static int calculateOffset(final @NotNull VirtualFile file, final int documentLine, final int documentColumn) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "calculateOffset"));
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Integer>(){

            public Integer compute() {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    int lineCount = document.getLineCount();
                    if (0 <= documentLine && documentLine < lineCount) {
                        int lineStartOffset = document.getLineStartOffset(documentLine);
                        int lineEndOffset = document.getLineEndOffset(documentLine);
                        int fixedColumn = Math.min(Math.max(documentColumn, 0), lineEndOffset - lineStartOffset);
                        return lineStartOffset + fixedColumn;
                    }
                }
                return -1;
            }
        });
    }
}

