/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Filter {
    public static final Filter[] EMPTY_ARRAY = new Filter[0];

    @Nullable
    public Result applyFilter(String var1, int var2);

    public static class ResultItem {
        public final int highlightStartOffset;
        public final int highlightEndOffset;
        public final TextAttributes highlightAttributes;
        public final HyperlinkInfo hyperlinkInfo;

        public ResultItem(int highlightStartOffset, int highlightEndOffset, HyperlinkInfo hyperlinkInfo) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, null);
        }

        public ResultItem(int highlightStartOffset, int highlightEndOffset, HyperlinkInfo hyperlinkInfo, TextAttributes highlightAttributes) {
            this.highlightStartOffset = highlightStartOffset;
            this.highlightEndOffset = highlightEndOffset;
            this.hyperlinkInfo = hyperlinkInfo;
            this.highlightAttributes = highlightAttributes;
        }
    }

    public static enum NextAction {
        EXIT,
        CONTINUE_FILTERING;

    }

    public static class Result
    extends ResultItem {
        protected NextAction myNextAction;
        protected List<ResultItem> myResultItems;

        public Result(int highlightStartOffset, int highlightEndOffset, HyperlinkInfo hyperlinkInfo) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, null);
        }

        public Result(int highlightStartOffset, int highlightEndOffset, HyperlinkInfo hyperlinkInfo, TextAttributes highlightAttributes) {
            super(highlightStartOffset, highlightEndOffset, hyperlinkInfo, highlightAttributes);
            this.myNextAction = NextAction.EXIT;
        }

        public Result(@NotNull List<ResultItem> resultItems) {
            if (resultItems == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/filters/Filter$Result", "<init>"));
            }
            super(-1, -1, null, null);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = resultItems;
        }

        public List<ResultItem> getResultItems() {
            List<ResultItem> resultItems = this.myResultItems;
            if (resultItems == null) {
                resultItems = Collections.singletonList(this);
            }
            return resultItems;
        }

        public NextAction getNextAction() {
            return this.myNextAction;
        }

        public void setNextAction(NextAction nextAction) {
            this.myNextAction = nextAction;
        }
    }
}

