/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionWorker {
    @NonNls
    private static final String AT = "at";
    private static final String AT_PREFIX = "at ";
    private static final String STANDALONE_AT = " at ";
    private static final TextAttributes HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    private static final TextAttributes LIBRARY_HYPERLINK_ATTRIBUTES = HYPERLINK_ATTRIBUTES.clone();
    private final Project myProject;
    private Filter.Result myResult;
    private PsiClass[] myClasses;
    private PsiFile[] myFiles;
    private String myMethod;
    private Trinity<TextRange, TextRange, TextRange> myInfo;
    private final ExceptionInfoCache myCache;

    public ExceptionWorker(@NotNull ExceptionInfoCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/filters/ExceptionWorker", "<init>"));
        }
        this.myClasses = PsiClass.EMPTY_ARRAY;
        this.myFiles = PsiFile.EMPTY_ARRAY;
        this.myProject = cache.getProject();
        this.myCache = cache;
    }

    public void execute(String line, int textEndOffset) {
        int rparenthIndex;
        this.myResult = null;
        this.myInfo = ExceptionWorker.parseExceptionLine(line);
        if (this.myInfo == null) {
            return;
        }
        this.myMethod = ((TextRange)this.myInfo.getSecond()).substring(line);
        int lparenthIndex = ((TextRange)this.myInfo.third).getStartOffset();
        String fileAndLine = line.substring(lparenthIndex + 1, rparenthIndex = ((TextRange)this.myInfo.third).getEndOffset()).trim();
        int colonIndex = fileAndLine.lastIndexOf(58);
        if (colonIndex < 0) {
            return;
        }
        String lineString = fileAndLine.substring(colonIndex + 1);
        try {
            ArrayList<VirtualFile> virtualFiles;
            TextAttributes attributes;
            int lineNumber = Integer.parseInt(lineString);
            Pair<PsiClass[], PsiFile[]> pair = this.myCache.resolveClass(((TextRange)this.myInfo.first).substring(line).trim());
            this.myClasses = (PsiClass[])pair.first;
            this.myFiles = (PsiFile[])pair.second;
            if (this.myFiles.length == 0) {
                this.myFiles = PsiShortNamesCache.getInstance(this.myProject).getFilesByName(fileAndLine.substring(0, colonIndex).trim());
            }
            if (this.myFiles.length == 0) {
                return;
            }
            int textStartOffset = textEndOffset - line.length();
            int highlightStartOffset = textStartOffset + lparenthIndex + 1;
            int highlightEndOffset = textStartOffset + rparenthIndex;
            ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            ArrayList<VirtualFile> virtualFilesInLibraries = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> virtualFilesInContent = new ArrayList<VirtualFile>();
            for (PsiFile file : this.myFiles) {
                VirtualFile virtualFile = file.getVirtualFile();
                if (index.isInContent(virtualFile)) {
                    virtualFilesInContent.add(virtualFile);
                    continue;
                }
                virtualFilesInLibraries.add(virtualFile);
            }
            if (virtualFilesInContent.isEmpty()) {
                attributes = LIBRARY_HYPERLINK_ATTRIBUTES;
                virtualFiles = virtualFilesInLibraries;
            } else {
                attributes = HYPERLINK_ATTRIBUTES;
                virtualFiles = virtualFilesInContent;
            }
            HyperlinkInfo linkInfo = HyperlinkInfoFactory.getInstance().createMultipleFilesHyperlinkInfo(virtualFiles, lineNumber - 1, this.myProject);
            this.myResult = new Filter.Result(highlightStartOffset, highlightEndOffset, linkInfo, attributes);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public Filter.Result getResult() {
        return this.myResult;
    }

    public PsiClass getPsiClass() {
        return (PsiClass)ArrayUtil.getFirstElement((Object[])this.myClasses);
    }

    public String getMethod() {
        return this.myMethod;
    }

    public PsiFile getFile() {
        return (PsiFile)ArrayUtil.getFirstElement((Object[])this.myFiles);
    }

    public Trinity<TextRange, TextRange, TextRange> getInfo() {
        return this.myInfo;
    }

    @Nullable
    static Trinity<TextRange, TextRange, TextRange> parseExceptionLine(String line) {
        int startIdx;
        if (line.startsWith(AT_PREFIX)) {
            startIdx = 0;
        } else {
            startIdx = line.indexOf(STANDALONE_AT);
            if (startIdx < 0) {
                startIdx = line.indexOf(AT_PREFIX);
            }
            if (startIdx < 0) {
                startIdx = -1;
            }
        }
        int lParenIdx = line.indexOf(40, startIdx);
        if (lParenIdx < 0) {
            return null;
        }
        int dotIdx = line.lastIndexOf(46, lParenIdx);
        if (dotIdx < 0 || dotIdx < startIdx) {
            return null;
        }
        int rParenIdx = line.indexOf(41, lParenIdx);
        if (rParenIdx < 0) {
            return null;
        }
        return Trinity.create((Object)new TextRange(startIdx + 1 + (startIdx >= 0 ? AT.length() : 0), ExceptionWorker.handleSpaces(line, dotIdx, -1, true)), (Object)new TextRange(ExceptionWorker.handleSpaces(line, dotIdx + 1, 1, true), ExceptionWorker.handleSpaces(line, lParenIdx + 1, -1, true)), (Object)new TextRange(lParenIdx, rParenIdx));
    }

    private static int handleSpaces(String line, int pos, int delta, boolean skip) {
        char c;
        int len = line.length();
        while (pos >= 0 && pos < len && skip == Character.isSpaceChar(c = line.charAt(pos))) {
            pos += delta;
        }
        return pos;
    }

    static {
        Color libTextColor = UIUtil.getInactiveTextColor();
        LIBRARY_HYPERLINK_ATTRIBUTES.setForegroundColor(libTextColor);
        LIBRARY_HYPERLINK_ATTRIBUTES.setEffectColor(libTextColor);
    }
}

