/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeFilter
implements Filter,
FilterMixin {
    private static final Logger LOG = Logger.getInstance(CompositeFilter.class);
    private final List<Filter> myFilters;
    private boolean myIsAnyHeavy;
    private final DumbService myDumbService;

    public CompositeFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/filters/CompositeFilter", "<init>"));
        }
        this.myFilters = new ArrayList<Filter>();
        this.myDumbService = DumbService.getInstance(project);
    }

    protected CompositeFilter(DumbService dumbService) {
        this.myFilters = new ArrayList<Filter>();
        this.myDumbService = dumbService;
    }

    @Override
    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        Filter.Result finalResult = null;
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (dumb && !DumbService.isDumbAware(filter)) continue;
            long t0 = System.currentTimeMillis();
            Filter.Result result = null;
            try {
                result = filter.applyFilter(line, entireLength);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + filter + " to '" + line + "'", t);
            }
            finalResult = this.merge(finalResult, result);
            t0 = System.currentTimeMillis() - t0;
            if (t0 > 1000L) {
                LOG.warn(filter.getClass().getSimpleName() + ".applyFilter() took " + t0 + " ms on '''" + line + "'''");
            }
            if (finalResult == null || finalResult.getNextAction() != Filter.NextAction.EXIT) continue;
            return finalResult;
        }
        return finalResult;
    }

    protected Filter.Result merge(@Nullable Filter.Result finalResult, @Nullable Filter.Result result) {
        if (result != null) {
            if (finalResult == null) {
                finalResult = result;
            } else {
                finalResult = new Filter.Result(this.mergeResultItems(finalResult, result));
                finalResult.setNextAction(result.getNextAction());
            }
        }
        return finalResult;
    }

    private List<Filter.ResultItem> mergeResultItems(Filter.Result finalResult, Filter.Result result) {
        List<Filter.ResultItem> finalResultResultItems = finalResult.getResultItems();
        List<Filter.ResultItem> resultItems = result.getResultItems();
        ArrayList<Filter.ResultItem> mergedList = new ArrayList<Filter.ResultItem>(finalResultResultItems.size() + resultItems.size());
        mergedList.addAll(finalResultResultItems);
        mergedList.addAll(resultItems);
        return mergedList;
    }

    @Override
    public boolean shouldRunHeavy() {
        for (Filter filter : this.myFilters) {
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyHeavyFilter(Document copiedFragment, int startOffset, int startLineNumber, Consumer<FilterMixin.AdditionalHighlight> consumer) {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy() || dumb && !DumbService.isDumbAware(filter)) continue;
            ((FilterMixin)((Object)filter)).applyHeavyFilter(copiedFragment, startOffset, startLineNumber, consumer);
        }
    }

    @Override
    public String getUpdateMessage() {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        ArrayList<String> updateMessage = new ArrayList<String>();
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy() || dumb && !DumbService.isDumbAware(filter)) continue;
            updateMessage.add(((FilterMixin)((Object)filter)).getUpdateMessage());
        }
        return updateMessage.size() == 1 ? (String)updateMessage.get(0) : "Updating...";
    }

    public boolean isEmpty() {
        return this.myFilters.isEmpty();
    }

    public boolean isAnyHeavy() {
        return this.myIsAnyHeavy;
    }

    public void addFilter(Filter filter) {
        this.myFilters.add(filter);
        this.myIsAnyHeavy |= filter instanceof FilterMixin;
    }
}

