/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.executors;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.UIBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefaultRunExecutor
extends Executor {
    @NonNls
    public static final String EXECUTOR_ID = ToolWindowId.RUN;

    @Override
    @NotNull
    public String getStartActionText() {
        String string = ExecutionBundle.message("default.runner.start.action.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/executors/DefaultRunExecutor", "getStartActionText"));
        }
        return string;
    }

    @Override
    public String getToolWindowId() {
        return ToolWindowId.RUN;
    }

    @Override
    public Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowRun;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.Execute;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/executors/DefaultRunExecutor", "getIcon"));
        }
        return icon;
    }

    @Override
    public Icon getDisabledIcon() {
        return AllIcons.Process.DisabledRun;
    }

    @Override
    public String getDescription() {
        return ExecutionBundle.message("standard.runner.description", new Object[0]);
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = UIBundle.message((String)"tool.window.name.run", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/executors/DefaultRunExecutor", "getActionName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        String string = EXECUTOR_ID;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/executors/DefaultRunExecutor", "getId"));
        }
        return string;
    }

    @Override
    public String getContextActionId() {
        return "RunClass";
    }

    @Override
    public String getHelpId() {
        return "ideaInterface.run";
    }

    public static Executor getRunExecutorInstance() {
        return ExecutorRegistry.getInstance().getExecutorById(EXECUTOR_ID);
    }
}

