/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCommandLine
implements UserDataHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.GeneralCommandLine");
    private String myExePath;
    private File myWorkDirectory;
    private final Map<String, String> myEnvParams;
    private boolean myPassParentEnvironment;
    private final ParametersList myProgramParams;
    private Charset myCharset;
    private boolean myRedirectErrorStream;
    private Map<Object, Object> myUserData;

    public GeneralCommandLine() {
        this.myExePath = null;
        this.myWorkDirectory = null;
        this.myEnvParams = new MyTHashMap();
        this.myPassParentEnvironment = true;
        this.myProgramParams = new ParametersList();
        this.myCharset = CharsetToolkit.getDefaultSystemCharset();
        this.myRedirectErrorStream = false;
        this.myUserData = null;
    }

    public GeneralCommandLine(String ... command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "<init>"));
        }
        this(Arrays.asList(command));
    }

    public GeneralCommandLine(@NotNull List<String> command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "<init>"));
        }
        this.myExePath = null;
        this.myWorkDirectory = null;
        this.myEnvParams = new MyTHashMap();
        this.myPassParentEnvironment = true;
        this.myProgramParams = new ParametersList();
        this.myCharset = CharsetToolkit.getDefaultSystemCharset();
        this.myRedirectErrorStream = false;
        this.myUserData = null;
        int size = command.size();
        if (size > 0) {
            this.setExePath(command.get(0));
            if (size > 1) {
                this.addParameters(command.subList(1, size));
            }
        }
    }

    public String getExePath() {
        return this.myExePath;
    }

    public void setExePath(@NotNull @NonNls String exePath) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "setExePath"));
        }
        this.myExePath = exePath.trim();
    }

    public File getWorkDirectory() {
        return this.myWorkDirectory;
    }

    public void setWorkDirectory(@Nullable @NonNls String path) {
        this.setWorkDirectory(path != null ? new File(path) : null);
    }

    public void setWorkDirectory(@Nullable File workDirectory) {
        this.myWorkDirectory = workDirectory;
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        Map<String, String> map = this.myEnvParams;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/GeneralCommandLine", "getEnvironment"));
        }
        return map;
    }

    public Map<String, String> getEnvParams() {
        return this.getEnvironment();
    }

    public void setEnvParams(@Nullable Map<String, String> envParams) {
        this.myEnvParams.clear();
        if (envParams != null) {
            this.myEnvParams.putAll(envParams);
        }
    }

    public void setPassParentEnvironment(boolean passParentEnvironment) {
        this.myPassParentEnvironment = passParentEnvironment;
    }

    public void setPassParentEnvs(boolean passParentEnvironment) {
        this.setPassParentEnvironment(passParentEnvironment);
    }

    public boolean isPassParentEnvironment() {
        return this.myPassParentEnvironment;
    }

    public void addParameters(String ... parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "addParameters"));
        }
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameter(@NotNull @NonNls String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "addParameter"));
        }
        this.myProgramParams.add(parameter);
    }

    public ParametersList getParametersList() {
        return this.myProgramParams;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/GeneralCommandLine", "getCharset"));
        }
        return charset;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "setCharset"));
        }
        this.myCharset = charset;
    }

    public boolean isRedirectErrorStream() {
        return this.myRedirectErrorStream;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.myRedirectErrorStream = redirectErrorStream;
    }

    public String getCommandLineString() {
        return this.getCommandLineString(null);
    }

    public String getCommandLineString(@Nullable String exeName) {
        ArrayList<String> commands = new ArrayList<String>();
        if (exeName != null) {
            commands.add(exeName);
        } else if (this.myExePath != null) {
            commands.add(this.myExePath);
        } else {
            commands.add("<null>");
        }
        commands.addAll(this.myProgramParams.getList());
        return ParametersList.join(commands);
    }

    @NotNull
    public String getPreparedCommandLine(@NotNull Platform platform) {
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "getPreparedCommandLine"));
        }
        String exePath = this.myExePath != null ? this.myExePath : "";
        String string = StringUtil.join((Collection)CommandLineUtil.toCommandLine((String)exePath, this.myProgramParams.getList(), (Platform)platform), (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/GeneralCommandLine", "getPreparedCommandLine"));
        }
        return string;
    }

    public Process createProcess() throws ExecutionException {
        List commands;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing [" + this.getCommandLineString() + "]");
        }
        try {
            this.checkWorkingDirectory();
            if (StringUtil.isEmptyOrSpaces((String)this.myExePath)) {
                throw new ExecutionException(IdeBundle.message("run.configuration.error.executable.not.specified", new Object[0]));
            }
            commands = CommandLineUtil.toCommandLine((String)this.myExePath, this.myProgramParams.getList());
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            throw e;
        }
        try {
            return this.startProcess(commands);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            throw new ProcessNotCreatedException(e.getMessage(), e, this);
        }
    }

    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "startProcess"));
        }
        ProcessBuilder builder = new ProcessBuilder(commands);
        this.setupEnvironment(builder.environment());
        builder.directory(this.myWorkDirectory);
        builder.redirectErrorStream(this.myRedirectErrorStream);
        return builder.start();
    }

    private void checkWorkingDirectory() throws ExecutionException {
        if (this.myWorkDirectory == null) {
            return;
        }
        if (!this.myWorkDirectory.exists()) {
            throw new ExecutionException(IdeBundle.message("run.configuration.error.working.directory.does.not.exist", this.myWorkDirectory.getAbsolutePath()));
        }
        if (!this.myWorkDirectory.isDirectory()) {
            throw new ExecutionException(IdeBundle.message("run.configuration.error.working.directory.not.directory", new Object[0]));
        }
    }

    protected void setupEnvironment(@NotNull Map<String, String> environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "setupEnvironment"));
        }
        environment.clear();
        if (this.myPassParentEnvironment) {
            environment.putAll(PlatformUtils.isAppCode() ? System.getenv() : EnvironmentUtil.getEnvironmentMap());
        }
        if (!this.myEnvParams.isEmpty()) {
            if (SystemInfo.isWindows) {
                THashMap envVars = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                envVars.putAll(environment);
                envVars.putAll(this.myEnvParams);
                environment.clear();
                environment.putAll((Map<String, String>)envVars);
            } else {
                environment.putAll(this.myEnvParams);
            }
        }
    }

    @NotNull
    public static String inescapableQuote(@NotNull String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "inescapableQuote"));
        }
        String string = CommandLineUtil.specialQuote((String)parameter);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/GeneralCommandLine", "inescapableQuote"));
        }
        return string;
    }

    public String toString() {
        return this.myExePath + " " + this.myProgramParams;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "getUserData"));
        }
        if (this.myUserData != null) {
            Object t = this.myUserData.get(key);
            return (T)t;
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/GeneralCommandLine", "putUserData"));
        }
        if (this.myUserData == null) {
            this.myUserData = ContainerUtil.newHashMap();
        }
        this.myUserData.put(key, value);
    }

    private static class MyTHashMap
    extends THashMap<String, String> {
        private MyTHashMap() {
        }

        public void putAll(Map<? extends String, ? extends String> map) {
            if (map != null) {
                super.putAll(map);
            }
        }
    }
}

