/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.extensions.Extensions;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ConfigurationTypeUtil {
    private ConfigurationTypeUtil() {
    }

    public static <T extends ConfigurationType> T findConfigurationType(Class<T> configurationTypeClass) {
        Object[] types;
        for (ConfigurationType configurationType : types = (ConfigurationType[])Extensions.getExtensions(ConfigurationType.CONFIGURATION_TYPE_EP)) {
            if (!configurationTypeClass.isInstance(configurationType)) continue;
            return (T)configurationType;
        }
        assert (false) : Arrays.toString(types) + " loader: " + configurationTypeClass.getClassLoader() + ", " + configurationTypeClass;
        return null;
    }

    public static boolean equals(@NotNull ConfigurationType type1, @NotNull ConfigurationType type2) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/ConfigurationTypeUtil", "equals"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/configurations/ConfigurationTypeUtil", "equals"));
        }
        return type1.getId().equals(type2.getId());
    }
}

