/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationTypeBase
implements ConfigurationType {
    private static final ConfigurationFactory[] EMPTY_FACTORIES = new ConfigurationFactory[0];
    private final String myId;
    private final String myDisplayName;
    private final String myDescription;
    private final Icon myIcon;
    private ConfigurationFactory[] myFactories;

    protected ConfigurationTypeBase(@NotNull String id, String displayName, String description, Icon icon) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configurations/ConfigurationTypeBase", "<init>"));
        }
        this.myId = id;
        this.myDisplayName = displayName;
        this.myDescription = description;
        this.myIcon = icon;
        this.myFactories = EMPTY_FACTORIES;
    }

    protected void addFactory(ConfigurationFactory factory) {
        this.myFactories = (ConfigurationFactory[])ArrayUtil.append((Object[])this.myFactories, (Object)factory);
    }

    @Override
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    public String getConfigurationTypeDescription() {
        return this.myDescription;
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/ConfigurationTypeBase", "getId"));
        }
        return string;
    }

    @Override
    public ConfigurationFactory[] getConfigurationFactories() {
        return this.myFactories;
    }
}

