/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.configuration.RunConfigurationExtensionBase;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationExtensionsManager<U extends RunConfigurationBase, T extends RunConfigurationExtensionBase<U>> {
    public static final Key<List<Element>> RUN_EXTENSIONS = Key.create((String)"run.extension.elements");
    private static final String EXT_ID_ATTR = "ID";
    private static final String EXTENSION_ROOT_ATTR = "EXTENSION";
    protected final ExtensionPointName<T> myExtensionPointName;
    private final StringInterner myInterner = new StringInterner();

    public RunConfigurationExtensionsManager(ExtensionPointName<T> extensionPointName) {
        this.myExtensionPointName = extensionPointName;
    }

    public void readExternal(@NotNull U configuration, @NotNull Element parentNode) throws InvalidDataException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "readExternal"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "readExternal"));
        }
        List children = parentNode.getChildren(this.getExtensionRootAttr());
        HashMap extensions = ContainerUtil.newHashMap();
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            extensions.put(extension.getSerializationId(), extension);
        }
        boolean found = true;
        for (Element o : children) {
            Element element = o;
            String extensionName = element.getAttributeValue(this.getIdAttrName());
            RunConfigurationExtensionBase extension = (RunConfigurationExtensionBase)extensions.remove(extensionName);
            if (extension != null) {
                extension.readExternal(configuration, element);
                continue;
            }
            found = false;
        }
        if (!found) {
            ArrayList<Element> copy = new ArrayList<Element>(children.size());
            for (Element child : children) {
                Element clone = child.clone();
                JDOMUtil.internElement((Element)clone, (StringInterner)this.myInterner);
                copy.add(clone);
            }
            configuration.putCopyableUserData(RUN_EXTENSIONS, copy);
        }
    }

    protected String getIdAttrName() {
        return EXT_ID_ATTR;
    }

    protected String getExtensionRootAttr() {
        return EXTENSION_ROOT_ATTR;
    }

    public void writeExternal(@NotNull U configuration, @NotNull Element parentNode) throws WriteExternalException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "writeExternal"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "writeExternal"));
        }
        TreeMap map = ContainerUtil.newTreeMap();
        List elements = (List)configuration.getCopyableUserData(RUN_EXTENSIONS);
        if (elements != null) {
            for (Element el : elements) {
                String name = el.getAttributeValue(this.getIdAttrName());
                map.put(name, el.clone());
            }
        }
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            Element el = new Element(this.getExtensionRootAttr());
            el.setAttribute(this.getIdAttrName(), extension.getSerializationId());
            try {
                extension.writeExternal(configuration, el);
            }
            catch (WriteExternalException e) {
                map.remove(extension.getSerializationId());
                continue;
            }
            map.put(extension.getSerializationId(), el);
        }
        for (Element val : map.values()) {
            parentNode.addContent(val);
        }
    }

    public <V extends U> void appendEditors(@NotNull U configuration, @NotNull SettingsEditorGroup<V> group) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "appendEditors"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "appendEditors"));
        }
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            SettingsEditor<U> editor = extension.createEditor(configuration);
            if (editor == null) continue;
            group.addEditor(extension.getEditorTitle(), editor);
        }
    }

    public void validateConfiguration(@NotNull U configuration, boolean isExecution) throws Exception {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "validateConfiguration"));
        }
        for (RunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, null)) {
            extension.validateConfiguration(configuration, isExecution);
        }
    }

    public void extendCreatedConfiguration(@NotNull U configuration, @NotNull Location location) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "extendCreatedConfiguration"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "extendCreatedConfiguration"));
        }
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            extension.extendCreatedConfiguration(configuration, location);
        }
    }

    public void extendTemplateConfiguration(@NotNull U configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "extendTemplateConfiguration"));
        }
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            extension.extendTemplateConfiguration(configuration);
        }
    }

    public void patchCommandLine(@NotNull U configuration, RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "patchCommandLine"));
        }
        if (cmdLine == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "patchCommandLine"));
        }
        if (runnerId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "patchCommandLine"));
        }
        for (RunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, runnerSettings)) {
            extension.patchCommandLine(configuration, runnerSettings, cmdLine, runnerId);
        }
    }

    public void attachExtensionsToProcess(@NotNull U configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "attachExtensionsToProcess"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "attachExtensionsToProcess"));
        }
        for (RunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, runnerSettings)) {
            extension.attachToProcess(configuration, handler, runnerSettings);
        }
    }

    private List<T> getApplicableExtensions(@NotNull U configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "getApplicableExtensions"));
        }
        ArrayList<RunConfigurationExtensionBase> extensions = new ArrayList<RunConfigurationExtensionBase>();
        for (RunConfigurationExtensionBase extension : (RunConfigurationExtensionBase[])Extensions.getExtensions(this.myExtensionPointName)) {
            if (!extension.isApplicableFor(configuration)) continue;
            extensions.add(extension);
        }
        return extensions;
    }

    private List<T> getEnabledExtensions(@NotNull U configuration, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionsManager", "getEnabledExtensions"));
        }
        ArrayList<RunConfigurationExtensionBase> extensions = new ArrayList<RunConfigurationExtensionBase>();
        for (RunConfigurationExtensionBase extension : (RunConfigurationExtensionBase[])Extensions.getExtensions(this.myExtensionPointName)) {
            if (!extension.isApplicableFor(configuration) || !extension.isEnabledFor(configuration, runnerSettings)) continue;
            extensions.add(extension);
        }
        return extensions;
    }
}

