/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationExtensionBase<T extends RunConfigurationBase> {
    @NotNull
    protected String getSerializationId() {
        String string = this.getClass().getCanonicalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/RunConfigurationExtensionBase", "getSerializationId"));
        }
        return string;
    }

    protected abstract void readExternal(@NotNull T var1, @NotNull Element var2) throws InvalidDataException;

    protected abstract void writeExternal(@NotNull T var1, @NotNull Element var2) throws WriteExternalException;

    @Nullable
    protected abstract <P extends T> SettingsEditor<P> createEditor(@NotNull P var1);

    @Nullable
    protected abstract String getEditorTitle();

    protected abstract boolean isApplicableFor(@NotNull T var1);

    protected abstract boolean isEnabledFor(@NotNull T var1, @Nullable RunnerSettings var2);

    protected abstract void patchCommandLine(@NotNull T var1, RunnerSettings var2, @NotNull GeneralCommandLine var3, @NotNull String var4) throws ExecutionException;

    protected void attachToProcess(@NotNull T configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionBase", "attachToProcess"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/configuration/RunConfigurationExtensionBase", "attachToProcess"));
        }
    }

    protected void validateConfiguration(@NotNull T configuration, boolean isExecution) throws Exception {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionBase", "validateConfiguration"));
        }
    }

    protected void extendCreatedConfiguration(@NotNull T configuration, @NotNull Location location) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionBase", "extendCreatedConfiguration"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/configuration/RunConfigurationExtensionBase", "extendCreatedConfiguration"));
        }
    }

    protected void extendTemplateConfiguration(@NotNull T configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/RunConfigurationExtensionBase", "extendTemplateConfiguration"));
        }
    }
}

