/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.util.EnvVariablesTable;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentVariablesComponent
extends LabeledComponent<TextFieldWithBrowseButton>
implements UserActivityProviderComponent {
    private boolean myPassParentEnvs;
    private final Map<String, String> myEnvs = new THashMap();
    @NonNls
    private static final String ENVS = "envs";
    @NonNls
    public static final String ENV = "env";
    @NonNls
    public static final String NAME = "name";
    @NonNls
    public static final String VALUE = "value";
    @NonNls
    private static final String OPTION = "option";
    @NonNls
    private static final String ENV_VARIABLES = "ENV_VARIABLES";
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public EnvironmentVariablesComponent() {
        TextFieldWithBrowseButton envsTestField = new TextFieldWithBrowseButton();
        envsTestField.setEditable(false);
        this.setComponent(envsTestField);
        this.setText(ExecutionBundle.message("environment.variables.component.title", new Object[0]));
        ((TextFieldWithBrowseButton)this.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new MyEnvironmentVariablesDialog().show();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/configuration/EnvironmentVariablesComponent", "setEnvs"));
        }
        this.myEnvs.clear();
        this.myEnvs.putAll(envs);
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            for (String variable : this.myEnvs.keySet()) {
                buf.append(variable).append("=").append(this.myEnvs.get(variable)).append(";");
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            ((TextFieldWithBrowseButton)this.getComponent()).setText(buf.toString());
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configuration/EnvironmentVariablesComponent", "getEnvs"));
        }
        return map;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passDefaultVariables) {
        if (this.myPassParentEnvs != passDefaultVariables) {
            this.myPassParentEnvs = passDefaultVariables;
            this.fireStateChanged();
        }
    }

    public static void readExternal(Element element, Map<String, String> envs) {
        Element envsElement = element.getChild(ENVS);
        if (envsElement != null) {
            Iterator i$ = envsElement.getChildren(ENV).iterator();
            while (i$.hasNext()) {
                Element o;
                Element envElement = o = (Element)i$.next();
                String envName = envElement.getAttributeValue(NAME);
                String envValue = envElement.getAttributeValue(VALUE);
                if (envName == null || envValue == null) continue;
                envs.put(envName, envValue);
            }
        } else {
            for (Element o : element.getChildren(OPTION)) {
                if (!Comparing.strEqual((String)o.getAttributeValue(NAME), (String)ENV_VARIABLES)) continue;
                EnvironmentVariablesComponent.splitVars(envs, o.getAttributeValue(VALUE));
                break;
            }
        }
    }

    private static void splitVars(Map<String, String> envs, String val) {
        String[] envVars;
        if (val != null && (envVars = val.split(";")) != null) {
            for (String envVar : envVars) {
                int idx = envVar.indexOf(61);
                if (idx <= -1) continue;
                envs.put(envVar.substring(0, idx), idx < envVar.length() - 1 ? envVar.substring(idx + 1) : "");
            }
        }
    }

    public static void writeExternal(Element element, Map<String, String> envs) {
        Element envsElement = new Element(ENVS);
        for (String envName : envs.keySet()) {
            Element envElement = new Element(ENV);
            envElement.setAttribute(NAME, envName);
            envElement.setAttribute(VALUE, envs.get(envName));
            envsElement.addContent(envElement);
        }
        element.addContent(envsElement);
    }

    public static void inlineParentOccurrences(Map<String, String> envs) {
        HashMap<String, String> parentParams = new HashMap<String, String>(System.getenv());
        for (String envKey : envs.keySet()) {
            String parentVal;
            String val = envs.get(envKey);
            if (val == null || (parentVal = (String)parentParams.get(envKey)) == null || !EnvironmentVariablesComponent.containsEnvKeySubstitution(envKey, val)) continue;
            envs.put(envKey, val.replace("$" + envKey + "$", parentVal));
        }
    }

    public static boolean containsEnvKeySubstitution(String envKey, String val) {
        return ArrayUtil.find((Object[])val.split(File.pathSeparator), (Object)("$" + envKey + "$")) != -1;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.myListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.myListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        for (ChangeListener listener : this.myListeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private class MyEnvironmentVariablesDialog
    extends DialogWrapper {
        private final EnvVariablesTable myEnvVariablesTable;
        private final JCheckBox myUseDefaultCb;
        private final JPanel myWholePanel;

        protected MyEnvironmentVariablesDialog() {
            super(EnvironmentVariablesComponent.this, true);
            this.myUseDefaultCb = new JCheckBox(ExecutionBundle.message("env.vars.checkbox.title", new Object[0]));
            this.myWholePanel = new JPanel(new BorderLayout());
            this.myEnvVariablesTable = new EnvVariablesTable();
            ArrayList<EnvironmentVariable> envVariables = new ArrayList<EnvironmentVariable>();
            for (String envVariable : EnvironmentVariablesComponent.this.myEnvs.keySet()) {
                envVariables.add(new EnvironmentVariable(envVariable, (String)EnvironmentVariablesComponent.this.myEnvs.get(envVariable), false));
            }
            this.myEnvVariablesTable.setValues(envVariables);
            this.myUseDefaultCb.setSelected(EnvironmentVariablesComponent.this.isPassParentEnvs());
            this.myWholePanel.add((Component)this.myEnvVariablesTable.getComponent(), "Center");
            this.myWholePanel.add((Component)this.myUseDefaultCb, "South");
            this.setTitle(ExecutionBundle.message("environment.variables.dialog.title", new Object[0]));
            this.init();
        }

        @Override
        @Nullable
        protected JComponent createCenterPanel() {
            return this.myWholePanel;
        }

        @Override
        protected void doOKAction() {
            this.myEnvVariablesTable.stopEditing();
            LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
            for (EnvironmentVariable variable : this.myEnvVariablesTable.getEnvironmentVariables()) {
                envs.put(variable.getName(), variable.getValue());
            }
            EnvironmentVariablesComponent.this.setEnvs(envs);
            EnvironmentVariablesComponent.this.setPassParentEnvs(this.myUseDefaultCb.isSelected());
            super.doOKAction();
        }
    }
}

