/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ConfigurationFromContextImpl
extends ConfigurationFromContext {
    private final RunConfigurationProducer myConfigurationProducer;
    private RunnerAndConfigurationSettings myConfigurationSettings;
    private final PsiElement mySourceElement;

    public ConfigurationFromContextImpl(RunConfigurationProducer producer, RunnerAndConfigurationSettings settings, PsiElement element) {
        this.myConfigurationProducer = producer;
        this.myConfigurationSettings = settings;
        this.mySourceElement = element;
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettings getConfigurationSettings() {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.myConfigurationSettings;
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ConfigurationFromContextImpl", "getConfigurationSettings"));
        }
        return runnerAndConfigurationSettings;
    }

    @Override
    public void setConfigurationSettings(RunnerAndConfigurationSettings configurationSettings) {
        this.myConfigurationSettings = configurationSettings;
    }

    @Override
    @NotNull
    public PsiElement getSourceElement() {
        PsiElement psiElement = this.mySourceElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ConfigurationFromContextImpl", "getSourceElement"));
        }
        return psiElement;
    }

    @Override
    public boolean isPreferredTo(ConfigurationFromContext other) {
        return this.myConfigurationProducer.isPreferredConfiguration(this, other);
    }

    @Override
    public boolean isProducedBy(Class<? extends RunConfigurationProducer> producerClass) {
        return producerClass.isInstance(this.myConfigurationProducer);
    }

    @Override
    public void onFirstRun(ConfigurationContext context, Runnable startRunnable) {
        this.myConfigurationProducer.onFirstRun(this, context, startRunnable);
    }
}

