/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import org.jetbrains.annotations.NotNull;

public class CantRunException
extends ExecutionException {
    public CantRunException(String message) {
        super(message);
    }

    public static CantRunException noModuleConfigured(String moduleName) {
        if (moduleName.trim().length() == 0) {
            return new CantRunException(ExecutionBundle.message("no.module.defined.error.message", new Object[0]));
        }
        return new CantRunException(ExecutionBundle.message("module.does.not.exist.error.message", moduleName));
    }

    public static CantRunException noJdkForModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/CantRunException", "noJdkForModule"));
        }
        return new CantRunException(ExecutionBundle.message("no.jdk.for.module.error.message", module.getName()));
    }

    public static CantRunException jdkMisconfigured(@NotNull Sdk jdk, @NotNull Module module) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/CantRunException", "jdkMisconfigured"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/CantRunException", "jdkMisconfigured"));
        }
        return new CantRunException(ExecutionBundle.message("jdk.is.bad.configured.error.message", jdk.getName()));
    }

    public static CantRunException classNotFound(@NotNull String className, @NotNull Module module) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/CantRunException", "classNotFound"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/CantRunException", "classNotFound"));
        }
        return new CantRunException(ExecutionBundle.message("class.not.found.in.module.error.message", className, module.getName()));
    }

    public static CantRunException packageNotFound(String packageName) {
        return new CantRunException(ExecutionBundle.message("package.not.found.error.message", packageName));
    }

    public static CantRunException noJdkConfigured(String jdkName) {
        if (jdkName != null) {
            return new CantRunException(ExecutionBundle.message("jdk.not.configured.error.message", jdkName));
        }
        return new CantRunException(ExecutionBundle.message("project.has.no.jdk.error.message", new Object[0]));
    }

    public static CantRunException badModuleDependencies() {
        return new CantRunException(ExecutionBundle.message("some.modules.has.circular.dependency.error.message", new Object[0]));
    }

    public static CantRunException noJdkConfigured() {
        return new CantRunException(ExecutionBundle.message("project.has.no.jdk.configured.error.message", new Object[0]));
    }
}

