/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class AsyncUtil {
    public static <V> V get(@NotNull Future<V> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/AsyncUtil", "get"));
        }
        try {
            return result.get();
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new Error(cause);
        }
    }
}

