/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class RefUtil {
    private RefUtil() {
    }

    public static boolean isImplicitUsage(PsiElement element) {
        ImplicitUsageProvider[] implicitUsageProviders;
        for (ImplicitUsageProvider provider : implicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions(ImplicitUsageProvider.EP_NAME)) {
            if (!provider.isImplicitUsage(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(RefEntity element, @NotNull Collection<RefEntity> entities) {
        if (entities == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/reference/RefUtil", "contains"));
        }
        for (RefEntity refEntity : entities) {
            if (!Comparing.equal((Object)refEntity, (Object)element)) continue;
            return true;
        }
        return false;
    }
}

