/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeToolState {
    private NamedScope myScope;
    @NotNull
    private final String myScopeName;
    private InspectionToolWrapper myToolWrapper;
    private boolean myEnabled;
    private HighlightDisplayLevel myLevel;
    private JComponent myAdditionalConfigPanel;
    private static final Logger LOG = Logger.getInstance((String)("#" + ScopeToolState.class.getName()));

    public ScopeToolState(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        this(scope.getName(), toolWrapper, enabled, level);
        this.myScope = scope;
    }

    public ScopeToolState(@NotNull String scopeName, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/ex/ScopeToolState", "<init>"));
        }
        this.myScopeName = scopeName;
        this.myToolWrapper = toolWrapper;
        this.myEnabled = enabled;
        this.myLevel = level;
    }

    @Nullable
    public NamedScope getScope(Project project) {
        if (this.myScope == null && project != null) {
            this.myScope = NamedScopesHolder.getScope(project, this.myScopeName);
        }
        return this.myScope;
    }

    @NotNull
    public String getScopeName() {
        String string = this.myScopeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ScopeToolState", "getScopeName"));
        }
        return string;
    }

    @NotNull
    public InspectionToolWrapper getTool() {
        InspectionToolWrapper inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ScopeToolState", "getTool"));
        }
        return inspectionToolWrapper;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    @NotNull
    public HighlightDisplayLevel getLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this.myLevel;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ScopeToolState", "getLevel"));
        }
        return highlightDisplayLevel;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void setLevel(@NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ScopeToolState", "setLevel"));
        }
        this.myLevel = level;
    }

    @NotNull
    public JComponent getAdditionalConfigPanel() {
        if (this.myAdditionalConfigPanel == null) {
            this.myAdditionalConfigPanel = ((InspectionProfileEntry)this.myToolWrapper.getTool()).createOptionsPanel();
            if (this.myAdditionalConfigPanel == null) {
                this.myAdditionalConfigPanel = new JPanel();
            }
        }
        JComponent jComponent = this.myAdditionalConfigPanel;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ScopeToolState", "getAdditionalConfigPanel"));
        }
        return jComponent;
    }

    public void resetConfigPanel() {
        this.myAdditionalConfigPanel = null;
    }

    public void setTool(@NotNull InspectionToolWrapper tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ScopeToolState", "setTool"));
        }
        this.myToolWrapper = tool;
    }

    public boolean equalTo(@NotNull ScopeToolState state2) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ScopeToolState", "equalTo"));
        }
        if (this.isEnabled() != state2.isEnabled()) {
            return false;
        }
        if (this.getLevel() != state2.getLevel()) {
            return false;
        }
        InspectionToolWrapper toolWrapper = this.getTool();
        InspectionToolWrapper toolWrapper2 = state2.getTool();
        if (!toolWrapper.isInitialized() && !toolWrapper2.isInitialized()) {
            return true;
        }
        try {
            String tempRoot = "root";
            Element oldToolSettings = new Element(tempRoot);
            ((InspectionProfileEntry)toolWrapper.getTool()).writeSettings(oldToolSettings);
            Element newToolSettings = new Element(tempRoot);
            ((InspectionProfileEntry)toolWrapper2.getTool()).writeSettings(newToolSettings);
            return JDOMUtil.areElementsEqual((Element)oldToolSettings, (Element)newToolSettings);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public void scopesChanged() {
        this.myScope = null;
    }
}

