/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSuppressableInspectionTool
extends LocalInspectionTool
implements BatchSuppressableTool {
    @NonNls
    static final String ALL = "ALL";

    @Override
    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SuppressTag(), new SuppressForFile(this.getID()), new SuppressAllForFile()};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "isSuppressedFor"));
        }
        return XmlSuppressionProvider.isSuppressed(element, this.getID());
    }

    public static class SuppressAllForFile
    extends SuppressForFile {
        public SuppressAllForFile() {
            super(XmlSuppressableInspectionTool.ALL);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("xml.suppressable.all.for.file.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressAllForFile", "getName"));
            }
            return string;
        }
    }

    public static class SuppressForFile
    implements SuppressQuickFix {
        private final String myInspectionId;

        public SuppressForFile(@NotNull String inspectionId) {
            if (inspectionId == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "<init>"));
            }
            this.myInspectionId = inspectionId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("xml.suppressable.for.file.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element == null || !element.isValid() || !(element.getContainingFile() instanceof XmlFile)) {
                return;
            }
            XmlSuppressionProvider.getProvider(element.getContainingFile()).suppressForFile(element, this.myInspectionId);
        }

        @Override
        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "isAvailable"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "isAvailable"));
            }
            return context.isValid();
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "getFamilyName"));
            }
            return string;
        }
    }

    public static class SuppressTagStatic
    implements SuppressQuickFix {
        private final String id;

        public SuppressTagStatic(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "<init>"));
            }
            this.id = id;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("xml.suppressable.for.tag.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "getName"));
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "isAvailable"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "isAvailable"));
            }
            return context.isValid();
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (PsiTreeUtil.getParentOfType(element, XmlTag.class) == null) {
                return;
            }
            XmlSuppressionProvider.getProvider(element.getContainingFile()).suppressForTag(element, this.id);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "getFamilyName"));
            }
            return string;
        }
    }

    public class SuppressTag
    extends SuppressTagStatic {
        public SuppressTag() {
            super(XmlSuppressableInspectionTool.this.getID());
        }
    }
}

