/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionProfileEntry {
    public static final String GENERAL_GROUP_NAME = InspectionsBundle.message("inspection.general.tools.group.name", new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionProfileEntry");
    private static final SkipDefaultValuesSerializationFilters DEFAULT_FILTER = new SkipDefaultValuesSerializationFilters();
    private static Set<String> ourBlackList = null;
    private static final Object BLACK_LIST_LOCK = new Object();
    private Boolean myUseNewSerializer = null;
    protected volatile DefaultNameProvider myNameProvider = null;

    public void cleanup(Project project) {
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultGroupDisplayName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getGroupDisplayName"));
            }
            return string;
        }
        LOG.error(this.getClass() + ": group display name should be overridden or configured via XML " + this.getClass());
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getGroupDisplayName"));
        }
        return "";
    }

    @NotNull
    public String[] getGroupPath() {
        String groupDisplayName = this.getGroupDisplayName();
        if (groupDisplayName.isEmpty()) {
            groupDisplayName = GENERAL_GROUP_NAME;
        }
        String[] stringArray = new String[]{groupDisplayName};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getGroupPath"));
        }
        return stringArray;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultDisplayName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getDisplayName"));
            }
            return string;
        }
        LOG.error(this.getClass() + ": display name should be overridden or configured via XML " + this.getClass());
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getDisplayName"));
        }
        return "";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultShortName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getShortName"));
            }
            return string;
        }
        String string = InspectionProfileEntry.getShortName(this.getClass().getSimpleName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getShortName"));
        }
        return string;
    }

    @NotNull
    public static String getShortName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/InspectionProfileEntry", "getShortName"));
        }
        String string = StringUtil.trimEnd((String)className, (String)"Inspection");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getShortName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return null;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/InspectionProfileEntry", "readSettings"));
        }
        if (this.useNewSerializer()) {
            try {
                XmlSerializer.deserializeInto((Object)this, (Element)node);
            }
            catch (XmlSerializationException e) {
                throw new InvalidDataException((Throwable)e);
            }
        } else {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)node);
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/InspectionProfileEntry", "writeSettings"));
        }
        if (this.useNewSerializer()) {
            XmlSerializer.serializeInto((Object)this, (Element)node, (SerializationFilter)this.getSerializationFilter());
        } else {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)node);
        }
    }

    private synchronized boolean useNewSerializer() {
        if (this.myUseNewSerializer == null) {
            this.myUseNewSerializer = !InspectionProfileEntry.getBlackList().contains(this.getClass().getName());
        }
        return this.myUseNewSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBlackList() {
        ourBlackList = ContainerUtil.newHashSet();
        URL url = InspectionProfileEntry.class.getResource("inspection-black-list.txt");
        if (url == null) {
            LOG.error("Resource not found");
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    ourBlackList.add(line);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load resource: " + url, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static Collection<String> getBlackList() {
        Object object = BLACK_LIST_LOCK;
        // MONITORENTER : object
        if (ourBlackList == null) {
            InspectionProfileEntry.loadBlackList();
        }
        Set<String> set = ourBlackList;
        // MONITOREXIT : object
        if (set != null) return set;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getBlackList"));
    }

    @Nullable
    protected SerializationFilter getSerializationFilter() {
        return DEFAULT_FILTER;
    }

    public void projectOpened(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/InspectionProfileEntry", "projectOpened"));
        }
    }

    public void projectClosed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/InspectionProfileEntry", "projectClosed"));
        }
    }

    @Nullable
    public String getStaticDescription() {
        return null;
    }

    @Nullable
    public String getDescriptionFileName() {
        return null;
    }

    @Nullable
    protected URL getDescriptionUrl() {
        String fileName = this.getDescriptionFileName();
        if (fileName == null) {
            return null;
        }
        return ResourceUtil.getResource(this.getDescriptionContextClass(), (String)"/inspectionDescriptions", (String)fileName);
    }

    @NotNull
    protected Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        Class<?> clazz = this.getClass();
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InspectionProfileEntry", "getDescriptionContextClass"));
        }
        return clazz;
    }

    public boolean isInitialized() {
        return true;
    }

    @Nullable
    public String getMainToolId() {
        return null;
    }

    @Nullable
    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            URL descriptionUrl = this.getDescriptionUrl();
            if (descriptionUrl == null) {
                return null;
            }
            return ResourceUtil.loadText((URL)descriptionUrl);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static interface DefaultNameProvider {
        @Nullable
        public String getDefaultShortName();

        @Nullable
        public String getDefaultDisplayName();

        @Nullable
        public String getDefaultGroupDisplayName();
    }
}

