/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LookupElementBuilder
extends LookupElement {
    @NotNull
    private final String myLookupString;
    @NotNull
    private final Object myObject;
    private final boolean myCaseSensitive;
    @Nullable
    private final InsertHandler<LookupElement> myInsertHandler;
    @Nullable
    private final LookupElementRenderer<LookupElement> myRenderer;
    @Nullable
    private final LookupElementPresentation myHardcodedPresentation;
    @NotNull
    private final Set<String> myAllLookupStrings;

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object, @Nullable InsertHandler<LookupElement> insertHandler, @Nullable LookupElementRenderer<LookupElement> renderer, @Nullable LookupElementPresentation hardcodedPresentation, @NotNull Set<String> allLookupStrings, boolean caseSensitive) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "<init>"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/lookup/LookupElementBuilder", "<init>"));
        }
        if (allLookupStrings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/codeInsight/lookup/LookupElementBuilder", "<init>"));
        }
        this.myLookupString = lookupString;
        this.myObject = object;
        this.myInsertHandler = insertHandler;
        this.myRenderer = renderer;
        this.myHardcodedPresentation = hardcodedPresentation;
        this.myAllLookupStrings = allLookupStrings;
        this.myCaseSensitive = caseSensitive;
    }

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "<init>"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/lookup/LookupElementBuilder", "<init>"));
        }
        this(lookupString, object, null, null, null, Collections.singleton(lookupString), true);
    }

    public static LookupElementBuilder create(@NotNull String lookupString) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "create"));
        }
        return new LookupElementBuilder(lookupString, lookupString);
    }

    public static LookupElementBuilder create(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "create"));
        }
        PsiUtilCore.ensureValid(element);
        return new LookupElementBuilder(StringUtil.notNullize((String)element.getName()), element);
    }

    public static LookupElementBuilder createWithIcon(@NotNull PsiNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "createWithIcon"));
        }
        PsiUtilCore.ensureValid(element);
        return LookupElementBuilder.create(element).withIcon(element.getIcon(0));
    }

    public static LookupElementBuilder create(@NotNull Object lookupObject, @NotNull String lookupString) {
        if (lookupObject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "create"));
        }
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/lookup/LookupElementBuilder", "create"));
        }
        if (lookupObject instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)lookupObject);
        }
        return new LookupElementBuilder(lookupString, lookupObject);
    }

    public LookupElementBuilder setInsertHandler(@Nullable InsertHandler<LookupElement> insertHandler) {
        return this.withInsertHandler(insertHandler);
    }

    public LookupElementBuilder withInsertHandler(@Nullable InsertHandler<LookupElement> insertHandler) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, insertHandler, this.myRenderer, this.myHardcodedPresentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setRenderer(@Nullable LookupElementRenderer<LookupElement> renderer) {
        return this.withRenderer(renderer);
    }

    public LookupElementBuilder withRenderer(@Nullable LookupElementRenderer<LookupElement> renderer) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, renderer, this.myHardcodedPresentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Override
    @NotNull
    public Set<String> getAllLookupStrings() {
        Set<String> set = this.myAllLookupStrings;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/LookupElementBuilder", "getAllLookupStrings"));
        }
        return set;
    }

    public LookupElementBuilder setIcon(@Nullable Icon icon) {
        return this.withIcon(icon);
    }

    public LookupElementBuilder withIcon(@Nullable Icon icon) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setIcon(icon);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @NotNull
    private LookupElementPresentation copyPresentation() {
        LookupElementPresentation presentation = new LookupElementPresentation();
        if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
        LookupElementPresentation lookupElementPresentation = presentation;
        if (lookupElementPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/LookupElementBuilder", "copyPresentation"));
        }
        return lookupElementPresentation;
    }

    public LookupElementBuilder addLookupString(@NotNull String another) {
        if (another == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "addLookupString"));
        }
        return this.withLookupString(another);
    }

    public LookupElementBuilder withLookupString(@NotNull String another) {
        if (another == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "withLookupString"));
        }
        THashSet set = new THashSet(this.myAllLookupStrings);
        set.add((Object)another);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, Collections.unmodifiableSet(set), this.myCaseSensitive);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public LookupElementBuilder setCaseSensitive(boolean caseSensitive) {
        return this.withCaseSensitivity(caseSensitive);
    }

    public LookupElementBuilder withCaseSensitivity(boolean caseSensitive) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, this.myAllLookupStrings, caseSensitive);
    }

    public LookupElementBuilder setItemTextForeground(@NotNull Color itemTextForeground) {
        if (itemTextForeground == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "setItemTextForeground"));
        }
        return this.withItemTextForeground(itemTextForeground);
    }

    public LookupElementBuilder withItemTextForeground(@NotNull Color itemTextForeground) {
        if (itemTextForeground == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "withItemTextForeground"));
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextForeground(itemTextForeground);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setItemTextUnderlined(boolean underlined) {
        return this.withItemTextUnderlined(underlined);
    }

    public LookupElementBuilder withItemTextUnderlined(boolean underlined) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextUnderlined(underlined);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setTypeText(@Nullable String typeText) {
        return this.withTypeText(typeText);
    }

    public LookupElementBuilder withTypeText(@Nullable String typeText) {
        return this.withTypeText(typeText, false);
    }

    public LookupElementBuilder setTypeText(@Nullable String typeText, boolean grayed) {
        return this.withTypeText(typeText, grayed);
    }

    public LookupElementBuilder withTypeText(@Nullable String typeText, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTypeText(typeText);
        presentation.setTypeGrayed(grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setPresentableText(@NotNull String presentableText) {
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "setPresentableText"));
        }
        return this.withPresentableText(presentableText);
    }

    public LookupElementBuilder withPresentableText(@NotNull String presentableText) {
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "withPresentableText"));
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemText(presentableText);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setBold() {
        return this.bold();
    }

    public LookupElementBuilder bold() {
        return this.withBoldness(true);
    }

    public LookupElementBuilder setBold(boolean bold) {
        return this.withBoldness(bold);
    }

    public LookupElementBuilder withBoldness(boolean bold) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextBold(bold);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setStrikeout() {
        return this.strikeout();
    }

    public LookupElementBuilder strikeout() {
        return this.withStrikeoutness(true);
    }

    public LookupElementBuilder setStrikeout(boolean strikeout) {
        return this.withStrikeoutness(strikeout);
    }

    public LookupElementBuilder withStrikeoutness(boolean strikeout) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setStrikeout(strikeout);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setTailText(@Nullable String tailText) {
        return this.withTailText(tailText);
    }

    public LookupElementBuilder withTailText(@Nullable String tailText) {
        return this.withTailText(tailText, false);
    }

    public LookupElementBuilder setTailText(@Nullable String tailText, boolean grayed) {
        return this.withTailText(tailText, grayed);
    }

    public LookupElementBuilder withTailText(@Nullable String tailText, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTailText(tailText, grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder appendTailText(@NotNull String tailText, boolean grayed) {
        if (tailText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/LookupElementBuilder", "appendTailText"));
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.appendTailText(tailText, grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElement withAutoCompletionPolicy(AutoCompletionPolicy policy) {
        return policy.applyPolicy(this);
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/LookupElementBuilder", "getLookupString"));
        }
        return string;
    }

    @Override
    @NotNull
    public Object getObject() {
        Object object = this.myObject;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/LookupElementBuilder", "getObject"));
        }
        return object;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        if (this.myInsertHandler != null) {
            this.myInsertHandler.handleInsert(context, this);
        }
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        if (this.myRenderer != null) {
            this.myRenderer.renderElement(this, presentation);
        } else if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LookupElementBuilder that = (LookupElementBuilder)((Object)o);
        InsertHandler<LookupElement> insertHandler = that.myInsertHandler;
        if (this.myInsertHandler != null && insertHandler != null ? !this.myInsertHandler.getClass().equals(insertHandler.getClass()) : this.myInsertHandler != insertHandler) {
            return false;
        }
        if (!this.myLookupString.equals(that.myLookupString)) {
            return false;
        }
        if (!this.myObject.equals(that.myObject)) {
            return false;
        }
        LookupElementRenderer<LookupElement> renderer = that.myRenderer;
        return !(this.myRenderer != null && renderer != null ? !this.myRenderer.getClass().equals(renderer.getClass()) : this.myRenderer != renderer);
    }

    @Override
    public String toString() {
        return "LookupElementBuilder: string=" + this.getLookupString() + "; handler=" + this.myInsertHandler;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.myInsertHandler != null ? this.myInsertHandler.getClass().hashCode() : 0);
        result = 31 * result + this.myLookupString.hashCode();
        result = 31 * result + this.myObject.hashCode();
        result = 31 * result + (this.myRenderer != null ? this.myRenderer.getClass().hashCode() : 0);
        return result;
    }
}

