/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkerInfo<T extends PsiElement> {
    protected final Icon myIcon;
    private final WeakReference<T> elementRef;
    public final int startOffset;
    public final int endOffset;
    public Color separatorColor;
    public SeparatorPlacement separatorPlacement;
    public RangeHighlighter highlighter;
    public final int updatePass;
    @Nullable
    private final Function<? super T, String> myTooltipProvider;
    private final GutterIconRenderer.Alignment myIconAlignment;
    @Nullable
    private final GutterIconNavigationHandler<T> myNavigationHandler;

    public LineMarkerInfo(@NotNull T element, int startOffset, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/LineMarkerInfo", "<init>"));
        }
        this((T)element, new TextRange(startOffset, startOffset), icon, updatePass, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment);
    }

    public LineMarkerInfo(@NotNull T element, @NotNull TextRange range, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/LineMarkerInfo", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/LineMarkerInfo", "<init>"));
        }
        this.myIcon = icon;
        this.myTooltipProvider = tooltipProvider;
        this.myIconAlignment = alignment;
        this.elementRef = new WeakReference<T>(element);
        this.myNavigationHandler = navHandler;
        this.startOffset = range.getStartOffset();
        this.updatePass = updatePass;
        this.endOffset = range.getEndOffset();
    }

    public LineMarkerInfo(@NotNull T element, int startOffset, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/LineMarkerInfo", "<init>"));
        }
        this((T)element, startOffset, icon, updatePass, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, GutterIconRenderer.Alignment.RIGHT);
    }

    @Nullable
    public GutterIconRenderer createGutterRenderer() {
        if (this.myIcon == null) {
            return null;
        }
        return new LineMarkerGutterIconRenderer(this);
    }

    @Nullable
    public String getLineMarkerTooltip() {
        T element = this.getElement();
        if (element == null || !element.isValid()) {
            return null;
        }
        if (this.myTooltipProvider != null) {
            return (String)this.myTooltipProvider.fun(element);
        }
        return null;
    }

    @Nullable
    public T getElement() {
        return (T)((PsiElement)this.elementRef.get());
    }

    @Nullable
    public GutterIconNavigationHandler<T> getNavigationHandler() {
        return this.myNavigationHandler;
    }

    public String toString() {
        return "(" + this.startOffset + "," + this.endOffset + ") -> " + this.elementRef.get();
    }

    public static class LineMarkerGutterIconRenderer<T extends PsiElement>
    extends GutterIconRenderer {
        private final LineMarkerInfo<T> myInfo;

        public LineMarkerGutterIconRenderer(@NotNull LineMarkerInfo<T> info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/LineMarkerInfo$LineMarkerGutterIconRenderer", "<init>"));
            }
            this.myInfo = info;
        }

        public LineMarkerInfo<T> getLineMarkerInfo() {
            return this.myInfo;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = this.myInfo.myIcon;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/LineMarkerInfo$LineMarkerGutterIconRenderer", "getIcon"));
            }
            return icon;
        }

        @Override
        public AnAction getClickAction() {
            LineMarkerInfo<T> lineMarkerInfo = this.myInfo;
            lineMarkerInfo.getClass();
            return lineMarkerInfo.new NavigateAction();
        }

        @Override
        public boolean isNavigateAction() {
            return ((LineMarkerInfo)this.myInfo).myNavigationHandler != null;
        }

        @Override
        public String getTooltipText() {
            try {
                return this.myInfo.getLineMarkerTooltip();
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
        }

        @Override
        public GutterIconRenderer.Alignment getAlignment() {
            return ((LineMarkerInfo)this.myInfo).myIconAlignment;
        }

        protected boolean looksTheSameAs(@NotNull LineMarkerGutterIconRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/LineMarkerInfo$LineMarkerGutterIconRenderer", "looksTheSameAs"));
            }
            return this.myInfo.getElement() != null && renderer.myInfo.getElement() != null && this.myInfo.getElement() == renderer.myInfo.getElement() && Comparing.equal((Object)((LineMarkerInfo)this.myInfo).myTooltipProvider, (Object)((LineMarkerInfo)renderer.myInfo).myTooltipProvider) && Comparing.equal((Object)this.myInfo.myIcon, (Object)renderer.myInfo.myIcon);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof LineMarkerGutterIconRenderer && this.looksTheSameAs((LineMarkerGutterIconRenderer)obj);
        }

        @Override
        public int hashCode() {
            T element = this.myInfo.getElement();
            return element == null ? 0 : element.hashCode();
        }
    }

    private class NavigateAction
    extends AnAction {
        private NavigateAction() {
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            if (LineMarkerInfo.this.myNavigationHandler != null) {
                MouseEvent mouseEvent = (MouseEvent)e.getInputEvent();
                Object element = LineMarkerInfo.this.getElement();
                if (element == null || !element.isValid()) {
                    return;
                }
                LineMarkerInfo.this.myNavigationHandler.navigate(mouseEvent, element);
            }
        }
    }
}

