/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public abstract class ImportFilter {
    public static final ExtensionPointName<ImportFilter> EP_NAME = new ExtensionPointName("com.intellij.importFilter");

    public abstract boolean shouldUseFullyQualifiedName(@NotNull PsiFile var1, @NotNull String var2);

    public static boolean shouldImport(@NotNull PsiFile targetFile, @NotNull String classQualifiedName) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/ImportFilter", "shouldImport"));
        }
        if (classQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/ImportFilter", "shouldImport"));
        }
        for (ImportFilter filter : (ImportFilter[])EP_NAME.getExtensions()) {
            if (!filter.shouldUseFullyQualifiedName(targetFile, classQualifiedName)) continue;
            return false;
        }
        return true;
    }
}

