/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.idea.Main;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class BootstrapClassLoaderUtil
extends ClassUtilCore {
    private static final String PROPERTY_IGNORE_CLASSPATH = "ignore.classpath";
    private static final String PROPERTY_ALLOW_BOOTSTRAP_RESOURCES = "idea.allow.bootstrap.resources";
    private static final String PROPERTY_ADDITIONAL_CLASSPATH = "idea.additional.classpath";

    private BootstrapClassLoaderUtil() {
    }

    private static Logger getLogger() {
        return Logger.getInstance(BootstrapClassLoaderUtil.class);
    }

    @NotNull
    public static UrlClassLoader initClassLoader(boolean updatePlugins) throws Exception {
        PathManager.loadProperties();
        ArrayList<URL> classpath = new ArrayList<URL>();
        BootstrapClassLoaderUtil.addParentClasspath(classpath);
        BootstrapClassLoaderUtil.addIDEALibraries(classpath);
        BootstrapClassLoaderUtil.addAdditionalClassPath(classpath);
        UrlClassLoader.Builder builder = UrlClassLoader.build().urls(BootstrapClassLoaderUtil.filterClassPath(classpath)).allowLock().useCache();
        if (Boolean.valueOf(System.getProperty(PROPERTY_ALLOW_BOOTSTRAP_RESOURCES, "false")).booleanValue()) {
            builder.allowBootstrapResources();
        }
        UrlClassLoader newClassLoader = builder.get();
        if (updatePlugins && !BootstrapClassLoaderUtil.isLoadingOfExternalPluginsDisabled()) {
            try {
                StartupActionScriptManager.executeActionScript();
            }
            catch (IOException e) {
                Main.showMessage("Plugin Installation Error", e);
            }
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)newClassLoader);
        UrlClassLoader urlClassLoader = newClassLoader;
        if (urlClassLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BootstrapClassLoaderUtil", "initClassLoader"));
        }
        return urlClassLoader;
    }

    private static List<URL> filterClassPath(List<URL> classpathElements) {
        String ignoreProperty = System.getProperty(PROPERTY_IGNORE_CLASSPATH);
        if (ignoreProperty != null) {
            Pattern pattern = Pattern.compile(ignoreProperty);
            Iterator<URL> i = classpathElements.iterator();
            while (i.hasNext()) {
                String url = i.next().toExternalForm();
                if (!pattern.matcher(url).matches()) continue;
                i.remove();
            }
        }
        return classpathElements;
    }

    private static void addParentClasspath(List<URL> aClasspathElements) throws MalformedURLException {
        ClassLoader loader = BootstrapClassLoaderUtil.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)loader;
            ContainerUtil.addAll(aClasspathElements, (Object[])urlClassLoader.getURLs());
        } else {
            String loaderName = loader.getClass().getName();
            try {
                Class<?> antClassLoaderClass = Class.forName("org.apache.tools.ant.AntClassLoader");
                if (antClassLoaderClass.isInstance(loader) || "org.apache.tools.ant.AntClassLoader".equals(loaderName) || "org.apache.tools.ant.loader.AntClassLoader2".equals(loaderName)) {
                    String classpath = (String)antClassLoaderClass.getDeclaredMethod("getClasspath", ArrayUtil.EMPTY_CLASS_ARRAY).invoke((Object)loader, ArrayUtil.EMPTY_OBJECT_ARRAY);
                    StringTokenizer tokenizer = new StringTokenizer(classpath, File.separator, false);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        aClasspathElements.add(new File(token).toURI().toURL());
                    }
                } else {
                    BootstrapClassLoaderUtil.getLogger().warn("Unknown class loader: " + loaderName);
                }
            }
            catch (ClassCastException e) {
                BootstrapClassLoaderUtil.logException(loaderName, e);
            }
            catch (ClassNotFoundException e) {
                BootstrapClassLoaderUtil.logException(loaderName, e);
            }
            catch (NoSuchMethodException e) {
                BootstrapClassLoaderUtil.logException(loaderName, e);
            }
            catch (IllegalAccessException e) {
                BootstrapClassLoaderUtil.logException(loaderName, e);
            }
            catch (InvocationTargetException e) {
                BootstrapClassLoaderUtil.logException(loaderName, e);
            }
        }
    }

    private static void logException(String loaderName, Exception e) {
        BootstrapClassLoaderUtil.getLogger().warn("Unknown class loader '" + loaderName + "'", (Throwable)e);
    }

    private static void addIDEALibraries(List<URL> classpathElements) {
        String ideaHomePath = PathManager.getHomePath();
        BootstrapClassLoaderUtil.addAllFromLibFolder(ideaHomePath, classpathElements);
    }

    private static void addAllFromLibFolder(String folderPath, List<URL> classPath) {
        try {
            Class<BootstrapClassLoaderUtil> aClass = BootstrapClassLoaderUtil.class;
            String selfRoot = PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
            assert (selfRoot != null);
            URL selfRootUrl = new File(selfRoot).getAbsoluteFile().toURI().toURL();
            classPath.add(selfRootUrl);
            File libFolder = new File(folderPath + File.separator + "lib");
            BootstrapClassLoaderUtil.addLibraries(classPath, libFolder, selfRootUrl);
            File extLib = new File(libFolder, "ext");
            BootstrapClassLoaderUtil.addLibraries(classPath, extLib, selfRootUrl);
            File antLib = new File(new File(libFolder, "ant"), "lib");
            BootstrapClassLoaderUtil.addLibraries(classPath, antLib, selfRootUrl);
        }
        catch (MalformedURLException e) {
            BootstrapClassLoaderUtil.getLogger().error((Throwable)e);
        }
    }

    private static void addLibraries(List<URL> classPath, File fromDir, URL selfRootUrl) throws MalformedURLException {
        File[] files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            URL url;
            if (!FileUtil.isJarOrZip((File)file) || selfRootUrl.equals(url = file.toURI().toURL())) continue;
            classPath.add(url);
        }
    }

    private static void addAdditionalClassPath(List<URL> classPath) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(System.getProperty(PROPERTY_ADDITIONAL_CLASSPATH, ""), File.pathSeparator, false);
            while (tokenizer.hasMoreTokens()) {
                String pathItem = tokenizer.nextToken();
                classPath.add(new File(pathItem).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            BootstrapClassLoaderUtil.getLogger().error((Throwable)e);
        }
    }
}

