/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import org.jetbrains.annotations.NotNull;

public class StringScanner {
    private final String myText;
    private int myPosition;

    public StringScanner(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/StringScanner", "<init>"));
        }
        this.myText = text;
        this.myPosition = 0;
    }

    public boolean hasMoreData() {
        return this.myPosition < this.myText.length();
    }

    public boolean isEol() {
        if (!this.hasMoreData()) {
            return true;
        }
        char ch = this.myText.charAt(this.myPosition);
        return ch == '\n' || ch == '\r';
    }

    public void nextLine() {
        while (!this.isEol()) {
            ++this.myPosition;
        }
        if (this.hasMoreData()) {
            char ch = this.myText.charAt(this.myPosition++);
            if (this.hasMoreData()) {
                char ch2 = this.myText.charAt(this.myPosition);
                if (ch == '\n' && ch2 == '\r' || ch == '\r' && ch2 == '\n') {
                    ++this.myPosition;
                }
            }
        }
    }

    public String spaceToken() {
        return this.boundedToken(' ');
    }

    public String tabToken() {
        return this.boundedToken('\t');
    }

    public String boundedToken(char boundaryChar) {
        return this.boundedToken(boundaryChar, false);
    }

    public String boundedToken(char boundaryChar, boolean ignoreEol) {
        int start = this.myPosition;
        while (this.myPosition < this.myText.length()) {
            char ch = this.myText.charAt(this.myPosition);
            if (ch == boundaryChar) {
                String rc = this.myText.substring(start, this.myPosition);
                ++this.myPosition;
                return rc;
            }
            if (!ignoreEol && this.isEol()) {
                return this.myText.substring(start, this.myPosition);
            }
            ++this.myPosition;
        }
        throw new IllegalStateException("Unexpected text end at " + this.myPosition);
    }

    public boolean startsWith(char c) {
        return this.hasMoreData() && this.myText.charAt(this.myPosition) == c;
    }

    public boolean startsWith(String text) {
        return this.myText.startsWith(text, this.myPosition);
    }

    public String line() {
        return this.line(false);
    }

    public String line(boolean includeNewLine) {
        int end;
        int start = this.myPosition;
        while (!this.isEol()) {
            ++this.myPosition;
        }
        if (includeNewLine) {
            this.nextLine();
            end = this.myPosition;
        } else {
            end = this.myPosition;
            this.nextLine();
        }
        return this.myText.substring(start, end);
    }

    public void skipChars(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Amount of chars to skip must be non neagitve: " + n);
        }
        if (this.myPosition + n >= this.myText.length()) {
            throw new IllegalArgumentException("Skipping beyond end of the text (" + this.myPosition + " + " + n + " >= " + this.myText.length() + ")");
        }
        this.myPosition += n;
    }

    public boolean tryConsume(char c) {
        if (this.startsWith(c)) {
            this.skipChars(1);
            return true;
        }
        return false;
    }

    public boolean tryConsume(String chars) {
        if (this.startsWith(chars)) {
            this.skipChars(chars.length());
            return true;
        }
        return false;
    }

    public char peek() {
        if (!this.hasMoreData()) {
            throw new IllegalStateException("There is no next character");
        }
        return this.myText.charAt(this.myPosition);
    }

    public String getAllText() {
        return this.myText;
    }
}

