/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.stash.GitStashChangesSaver;
import git4idea.util.GitFreezingProcess;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPreservingProcess {
    private static final Logger LOG = Logger.getInstance(GitPreservingProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitPlatformFacade myFacade;
    @NotNull
    private final Git myGit;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    @NotNull
    private final String myOperationTitle;
    @NotNull
    private final String myDestinationName;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final Runnable myOperation;
    @NotNull
    private final String myStashMessage;
    private GitStashChangesSaver mySaver;
    private boolean myLoaded;
    private final Object LOAD_LOCK;

    public GitPreservingProcess(@NotNull Project project, @NotNull GitPlatformFacade facade, @NotNull Git git, @NotNull Collection<GitRepository> repositories, @NotNull String operationTitle, @NotNull String destinationName, @NotNull ProgressIndicator indicator, @NotNull Runnable operation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (operationTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (destinationName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "git4idea/util/GitPreservingProcess", "<init>"));
        }
        this.LOAD_LOCK = new Object();
        this.myProject = project;
        this.myFacade = facade;
        this.myGit = git;
        this.myRepositories = repositories;
        this.myOperationTitle = operationTitle;
        this.myDestinationName = destinationName;
        this.myProgressIndicator = indicator;
        this.myOperation = operation;
        this.myStashMessage = String.format("%s %s at %s", StringUtil.capitalize((String)this.myOperationTitle), this.myDestinationName, DateFormatUtil.formatDateTime((long)Clock.getTime()));
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(final @Nullable Computable<Boolean> autoLoadDecision) {
        Runnable operation = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOG.debug("starting");
                GitPreservingProcess.this.mySaver = GitPreservingProcess.this.configureSaver();
                boolean savedSuccessfully = GitPreservingProcess.this.save();
                LOG.debug("save result: " + savedSuccessfully);
                if (savedSuccessfully) {
                    try {
                        LOG.debug("running operation");
                        GitPreservingProcess.this.myOperation.run();
                        LOG.debug("operation completed.");
                    }
                    finally {
                        if (autoLoadDecision == null || ((Boolean)autoLoadDecision.compute()).booleanValue()) {
                            LOG.debug("loading");
                            GitPreservingProcess.this.load();
                        }
                    }
                }
                LOG.debug("finished.");
            }
        };
        new GitFreezingProcess(this.myProject, this.myFacade, this.myOperationTitle, operation).execute();
    }

    private GitStashChangesSaver configureSaver() {
        GitStashChangesSaver saver = new GitStashChangesSaver(this.myProject, this.myFacade, this.myGit, this.myProgressIndicator, this.myStashMessage);
        MergeDialogCustomizer mergeDialogCustomizer = new MergeDialogCustomizer(){

            public String getMultipleFileMergeDescription(Collection<VirtualFile> files) {
                return String.format("<html>Uncommitted changes that were saved before %s have conflicts with files from <code>%s</code></html>", GitPreservingProcess.this.myOperationTitle, GitPreservingProcess.this.myDestinationName);
            }

            public String getLeftPanelTitle(VirtualFile file) {
                return "Uncommitted changes from stash";
            }

            public String getRightPanelTitle(VirtualFile file, VcsRevisionNumber lastRevisionNumber) {
                return String.format("<html>Changes from <b><code>%s</code></b></html>", GitPreservingProcess.this.myDestinationName);
            }
        };
        GitConflictResolver.Params params = new GitConflictResolver.Params().setReverse(true).setMergeDialogCustomizer(mergeDialogCustomizer).setErrorNotificationTitle("Local changes were not restored");
        saver.setConflictResolverParams(params);
        return saver;
    }

    private boolean save() {
        try {
            this.mySaver.saveLocalChanges(GitUtil.getRootsFromRepositories(this.myRepositories));
            return true;
        }
        catch (VcsException e) {
            LOG.info("Couldn't save local changes", (Throwable)e);
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Couldn't save uncommitted changes.", String.format("Tried to save uncommitted changes in stash before %s, but failed with an error.<br/>%s", this.myOperationTitle, StringUtil.join((String[])e.getMessages())));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.LOAD_LOCK;
        synchronized (object) {
            if (this.myLoaded) {
                return;
            }
            try {
                this.mySaver.load();
                this.myLoaded = true;
            }
            catch (VcsException e) {
                LOG.info("Couldn't load local changes", (Throwable)e);
                VcsNotifier.getInstance((Project)this.myProject).notifyError("Couldn't restore uncommitted changes", String.format("Tried to unstash uncommitted changes, but failed with error.<br/>%s", StringUtil.join((String[])e.getMessages())));
            }
        }
    }
}

